/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.FloatList;
import org.apache.commons.collections.primitives.decorators.BaseUnmodifiableFloatList;
import org.apache.commons.collections.primitives.decorators.NonSerializableUnmodifiableFloatList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public final class UnmodifiableFloatList
extends BaseUnmodifiableFloatList
implements Serializable {
    private transient FloatList m_aProxied;

    UnmodifiableFloatList(@Nonnull FloatList floatList) {
        this.m_aProxied = floatList;
    }

    @Override
    @Nonnull
    protected FloatList getProxiedList() {
        return this.m_aProxied;
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m_aProxied);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_aProxied = (FloatList)objectInputStream.readObject();
    }

    @Nullable
    public static final FloatList wrap(@Nullable FloatList floatList) {
        if (null == floatList) {
            return null;
        }
        if (floatList instanceof UnmodifiableFloatList) {
            return floatList;
        }
        if (floatList instanceof Serializable) {
            return new UnmodifiableFloatList(floatList);
        }
        return new NonSerializableUnmodifiableFloatList(floatList);
    }
}

