/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.collections.primitives.decorators.ProxyIntIterator;

public final class UnmodifiableIntIterator
extends ProxyIntIterator {
    private IntIterator m_aProxied;

    UnmodifiableIntIterator(@Nonnull IntIterator intIterator) {
        this.m_aProxied = intIterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This IntIterator is not modifiable.");
    }

    @Override
    @Nonnull
    protected IntIterator getIterator() {
        return this.m_aProxied;
    }

    @Nullable
    public static final IntIterator wrap(@Nullable IntIterator intIterator) {
        if (null == intIterator) {
            return null;
        }
        if (intIterator instanceof UnmodifiableIntIterator) {
            return intIterator;
        }
        return new UnmodifiableIntIterator(intIterator);
    }
}

