/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.ShortListIterator;
import org.apache.commons.collections.primitives.decorators.ProxyShortListIterator;

public final class UnmodifiableShortListIterator
extends ProxyShortListIterator {
    private ShortListIterator m_aProxied;

    UnmodifiableShortListIterator(@Nonnull ShortListIterator shortListIterator) {
        this.m_aProxied = shortListIterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This ShortListIterator is not modifiable.");
    }

    @Override
    public void add(short s) {
        throw new UnsupportedOperationException("This ShortListIterator is not modifiable.");
    }

    @Override
    public void set(short s) {
        throw new UnsupportedOperationException("This ShortListIterator is not modifiable.");
    }

    @Override
    protected ShortListIterator getListIterator() {
        return this.m_aProxied;
    }

    @Nullable
    public static final ShortListIterator wrap(@Nullable ShortListIterator shortListIterator) {
        if (null == shortListIterator) {
            return null;
        }
        if (shortListIterator instanceof UnmodifiableShortListIterator) {
            return shortListIterator;
        }
        return new UnmodifiableShortListIterator(shortListIterator);
    }
}

