/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.finder;

import java.util.ArrayList;
import java.util.Collections;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionFinder;
import org.nuxeo.ecm.platform.publisher.impl.finder.AbstractRootSectionsFinder;

public class DefaultRootSectionsFinder
extends AbstractRootSectionsFinder
implements RootSectionFinder {
    public DefaultRootSectionsFinder(CoreSession userSession) {
        super(userSession);
    }

    @Override
    protected void computeUserSectionRoots(DocumentModel currentDoc) throws ClientException {
        this.currentDocument = currentDoc;
        this.runUnrestricted();
        if (currentDoc != null) {
            this.accessibleSectionRoots = !this.unrestrictedSectionRootFromWorkspaceConfig.isEmpty() ? this.getFiltredSectionRoots(this.unrestrictedSectionRootFromWorkspaceConfig, true) : this.getFiltredSectionRoots(this.unrestrictedDefaultSectionRoot, true);
        }
    }

    @Override
    protected String buildQuery(String path) {
        String query = "SELECT * FROM Document WHERE ecm:path STARTSWITH " + NXQL.escapeString((String)path) + " and (";
        int i = 0;
        for (String type : this.getSectionTypes()) {
            query = query + " ecm:primaryType = '" + type + "'";
            if (++i < this.getSectionTypes().size()) {
                query = query + " or ";
                continue;
            }
            query = query + " )";
        }
        query = query + " order by ecm:path ";
        return query;
    }

    @Override
    protected void computeUnrestrictedRoots(CoreSession session) throws ClientException {
        if (this.currentDocument != null) {
            DocumentModel parentDocumentModel = this.currentDocument;
            while (!parentDocumentModel.hasSchema("publishing") && !"Root".equals(parentDocumentModel.getType())) {
                parentDocumentModel = session.getDocument(parentDocumentModel.getParentRef());
            }
            DocumentModelList sectionRootsFromWorkspaceConfig = this.getSectionRootsFromWorkspaceConfig(parentDocumentModel, session);
            this.unrestrictedSectionRootFromWorkspaceConfig = new ArrayList();
            for (DocumentModel root : sectionRootsFromWorkspaceConfig) {
                this.unrestrictedSectionRootFromWorkspaceConfig.add(root.getPathAsString());
            }
        }
        if (this.unrestrictedDefaultSectionRoot == null) {
            this.unrestrictedDefaultSectionRoot = Collections.emptyList();
        }
    }
}

