/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.service.FileSystemChangeFinder;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemChange;
import org.nuxeo.drive.service.NuxeoDriveEvents;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.drive.service.TooManyChangesException;
import org.nuxeo.drive.service.impl.FileSystemItemChangeImpl;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class AuditChangeFinder
implements FileSystemChangeFinder {
    private static final long serialVersionUID = 1963018967324857522L;
    private static final Log log = LogFactory.getLog(AuditChangeFinder.class);
    protected Map<String, String> parameters = new HashMap<String, String>();

    @Override
    public void handleParameters(Map<String, String> parameters) throws ClientException {
        this.parameters.putAll(parameters);
    }

    @Override
    public List<FileSystemItemChange> getFileSystemChanges(CoreSession session, Set<IdRef> lastActiveRootRefs, SynchronizationRoots activeRoots, long lastSuccessfulSyncDate, long syncDate, int limit) throws ClientException, TooManyChangesException {
        return this.getFileSystemChanges(session, lastActiveRootRefs, activeRoots, null, lastSuccessfulSyncDate, syncDate, false, limit);
    }

    @Override
    public List<FileSystemItemChange> getFileSystemChangesIntegerBounds(CoreSession session, Set<IdRef> lastActiveRootRefs, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, int limit) throws ClientException, TooManyChangesException {
        return this.getFileSystemChanges(session, lastActiveRootRefs, activeRoots, collectionSyncRootMemberIds, lowerBound, upperBound, true, limit);
    }

    protected List<FileSystemItemChange> getFileSystemChanges(CoreSession session, Set<IdRef> lastActiveRootRefs, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, boolean integerBounds, int limit) throws ClientException, TooManyChangesException {
        String principalName = session.getPrincipal().getName();
        ArrayList<FileSystemItemChange> changes = new ArrayList<FileSystemItemChange>();
        List<LogEntry> entries = this.queryAuditEntries(session, activeRoots, collectionSyncRootMemberIds, lowerBound, upperBound, integerBounds, limit);
        for (LogEntry entry : entries) {
            if (!NuxeoDriveEvents.EVENT_CATEGORY.equals(entry.getCategory())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Detected sync root change for user '%s' in audit log: invalidating the root cache and refetching the changes.", principalName));
            }
            NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
            driveManager.invalidateSynchronizationRootsCache(principalName);
            driveManager.invalidateCollectionSyncRootMemberCache(principalName);
            Map<String, SynchronizationRoots> synchronizationRoots = driveManager.getSynchronizationRoots(session.getPrincipal());
            SynchronizationRoots updatedActiveRoots = synchronizationRoots.get(session.getRepositoryName());
            Set<String> updatedCollectionSyncRootMemberIds = driveManager.getCollectionSyncRootMemberIds(session.getPrincipal()).get(session.getRepositoryName());
            entries = this.queryAuditEntries(session, updatedActiveRoots, updatedCollectionSyncRootMemberIds, lowerBound, upperBound, integerBounds, limit);
            break;
        }
        if (entries.size() >= limit) {
            throw new TooManyChangesException("Too many changes found in the audit logs.");
        }
        for (LogEntry entry : entries) {
            FileSystemItemChange change = null;
            IdRef docRef = new IdRef(entry.getDocUUID());
            ExtendedInfo fsIdInfo = (ExtendedInfo)entry.getExtendedInfos().get("fileSystemItemId");
            if (fsIdInfo != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found extended info in audit log entry, document %s has been deleted or is an unregistered synchronization root.", docRef));
                }
                boolean isChangeSet = false;
                if (!"deleted".equals(entry.getEventId()) && session.exists((DocumentRef)docRef) && (change = this.getFileSystemItemChange(session, (DocumentRef)docRef, entry, (String)fsIdInfo.getValue(String.class))) != null) {
                    if ("moved".equals(entry.getEventId())) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("Document %s has been moved to another synchronzation root, not adding entry to the change summary.", docRef));
                        continue;
                    }
                    isChangeSet = true;
                }
                if (!isChangeSet) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Document %s doesn't exist or is not adaptable as a FileSystemItem, only providing the FileSystemItem id and name to the FileSystemItemChange entry.", docRef));
                    }
                    String fsId = (String)fsIdInfo.getValue(String.class);
                    String eventId = "moved".equals(entry.getEventId()) ? "deleted" : entry.getEventId();
                    change = new FileSystemItemChangeImpl(eventId, entry.getEventDate().getTime(), entry.getRepositoryId(), entry.getDocUUID(), fsId, null);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Adding FileSystemItemChange entry for document %s to the change summary.", docRef));
                }
                changes.add(change);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("No extended info found in audit log entry, document %s has not been deleted nor is an unregistered synchronization root.", docRef));
            }
            if (!session.exists((DocumentRef)docRef)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Document %s doesn't exist, not adding entry to the change summary.", docRef));
                continue;
            }
            change = this.getFileSystemItemChange(session, (DocumentRef)docRef, entry, null);
            if (change == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Document %s is not adaptable as a FileSystemItem, not adding any entry to the change summary.", docRef));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Adding FileSystemItemChange entry for document %s to the change summary.", docRef));
            }
            changes.add(change);
        }
        return changes;
    }

    @Override
    public long getCurrentDate() {
        long now = System.currentTimeMillis();
        return now - now % 1000L;
    }

    @Override
    public long getUpperBound() {
        List entries;
        AuditReader auditService = (AuditReader)Framework.getService(AuditReader.class);
        String auditQuery = "from LogEntry log order by log.id desc";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Querying audit log for greatest id: " + auditQuery));
        }
        if ((entries = auditService.nativeQuery(auditQuery, 1, 1)).isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found no audit log entries, returning -1");
            }
            return -1L;
        }
        return ((LogEntry)entries.get(0)).getId();
    }

    @Override
    public long getUpperBound(Set<String> repositoryNames) {
        List entries;
        long clusteringDelay = this.getClusteringDelay(repositoryNames);
        AuditReader auditService = (AuditReader)Framework.getService(AuditReader.class);
        HashMap<String, Date> params = new HashMap<String, Date>();
        StringBuilder auditQuerySb = new StringBuilder("from LogEntry log");
        if (clusteringDelay > -1L) {
            long lastClusteringInvalidationDate = System.currentTimeMillis() - 2L * clusteringDelay;
            params.put("lastClusteringInvalidationDate", new Date(lastClusteringInvalidationDate));
            auditQuerySb.append(" where log.logDate < :lastClusteringInvalidationDate");
        }
        auditQuerySb.append(" order by log.id desc");
        String auditQuery = auditQuerySb.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Querying audit log for greatest id: " + auditQuery + " with params: " + params));
        }
        if ((entries = auditService.nativeQuery(auditQuery, params, 1, 1)).isEmpty()) {
            List allEntries;
            if (clusteringDelay > -1L && !(allEntries = auditService.nativeQuery("from LogEntry", 1, 1)).isEmpty()) {
                log.debug((Object)"Found no audit log entries matching the criterias but some exist, returning 0");
                return 0L;
            }
            log.debug((Object)"Found no audit log entries, returning -1");
            return -1L;
        }
        return ((LogEntry)entries.get(0)).getId();
    }

    protected long getClusteringDelay(Set<String> repositoryNames) {
        long clusteringDelay = -1L;
        SQLRepositoryService repositoryService = (SQLRepositoryService)Framework.getService(SQLRepositoryService.class);
        for (String repositoryName : repositoryNames) {
            RepositoryDescriptor repositoryDescriptor = repositoryService.getRepositoryDescriptor(repositoryName);
            if (repositoryDescriptor == null || !repositoryDescriptor.getClusteringEnabled()) continue;
            clusteringDelay = Math.max(clusteringDelay, repositoryDescriptor.getClusteringDelay());
        }
        return clusteringDelay;
    }

    protected List<LogEntry> queryAuditEntries(CoreSession session, SynchronizationRoots activeRoots, Set<String> collectionSyncRootMemberIds, long lowerBound, long upperBound, boolean integerBounds, int limit) {
        AuditReader auditService = (AuditReader)Framework.getLocalService(AuditReader.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("repositoryId", session.getRepositoryName());
        StringBuilder auditQuerySb = new StringBuilder("from LogEntry log where ");
        auditQuerySb.append("log.repositoryId = :repositoryId");
        auditQuerySb.append(" and ");
        auditQuerySb.append("(");
        if (!activeRoots.getPaths().isEmpty()) {
            auditQuerySb.append("(");
            auditQuerySb.append("log.category = 'eventDocumentCategory'");
            auditQuerySb.append(" and (log.eventId = 'documentCreated' or log.eventId = 'documentModified' or log.eventId = 'documentMoved' or log.eventId = 'documentCreatedByCopy' or log.eventId = 'documentRestored' or log.eventId = 'addedToCollection' or log.eventId = 'documentLocked' or log.eventId = 'documentUnlocked')");
            auditQuerySb.append(" or ");
            auditQuerySb.append("log.category = 'eventLifeCycleCategory'");
            auditQuerySb.append(" and log.eventId = 'lifecycle_transition_event' and log.docLifeCycle != 'deleted' ");
            auditQuerySb.append(") and (");
            auditQuerySb.append("(");
            auditQuerySb.append(this.getCurrentRootFilteringClause(activeRoots.getPaths(), params));
            auditQuerySb.append(")");
            if (collectionSyncRootMemberIds != null && !collectionSyncRootMemberIds.isEmpty()) {
                auditQuerySb.append(" or (");
                auditQuerySb.append(this.getCollectionSyncRootFilteringClause(collectionSyncRootMemberIds, params));
                auditQuerySb.append(")");
            }
            auditQuerySb.append(") or ");
        }
        auditQuerySb.append("(");
        auditQuerySb.append("log.category = '");
        auditQuerySb.append(NuxeoDriveEvents.EVENT_CATEGORY);
        auditQuerySb.append("' and log.eventId != 'rootUnregistered'");
        auditQuerySb.append(")");
        auditQuerySb.append(") and (");
        auditQuerySb.append(this.getJPARangeClause(lowerBound, upperBound, integerBounds, params));
        auditQuerySb.append(") order by log.repositoryId asc, log.eventDate desc");
        String auditQuery = auditQuerySb.toString();
        if (log.isDebugEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Querying audit log for changes: " + auditQuery + " with params: " + params));
        }
        List entries = auditService.nativeQuery(auditQuery, params, 1, limit);
        ArrayList<LogEntry> postFilteredEntries = new ArrayList<LogEntry>();
        String principalName = session.getPrincipal().getName();
        for (LogEntry entry : entries) {
            ExtendedInfo impactedUserInfo = (ExtendedInfo)entry.getExtendedInfos().get("impactedUserName");
            if (impactedUserInfo != null && !principalName.equals(impactedUserInfo.getValue(String.class))) continue;
            if (log.isDebugEnabled() && log.isDebugEnabled()) {
                log.debug((Object)String.format("Change with eventId=%d detected at eventDate=%s, logDate=%s: %s on %s", entry.getId(), entry.getEventDate(), entry.getLogDate(), entry.getEventId(), entry.getDocPath()));
            }
            postFilteredEntries.add(entry);
        }
        return postFilteredEntries;
    }

    protected String getCurrentRootFilteringClause(Set<String> rootPaths, Map<String, Object> params) {
        StringBuilder rootPathClause = new StringBuilder();
        int rootPathCount = 0;
        for (String rootPath : rootPaths) {
            String rootPathParam = "rootPath" + ++rootPathCount;
            if (rootPathClause.length() > 0) {
                rootPathClause.append(" or ");
            }
            rootPathClause.append(String.format("log.docPath like :%s", rootPathParam));
            params.put(rootPathParam, rootPath + '%');
        }
        return rootPathClause.toString();
    }

    protected String getCollectionSyncRootFilteringClause(Set<String> collectionSyncRootMemberIds, Map<String, Object> params) {
        String paramName = "collectionMemberIds";
        params.put(paramName, collectionSyncRootMemberIds);
        return String.format("log.docUUID in (:%s)", paramName);
    }

    protected String getJPARangeClause(long lowerBound, long upperBound, boolean integerBounds, Map<String, Object> params) {
        if (integerBounds) {
            params.put("lowerBound", lowerBound);
            params.put("upperBound", upperBound);
            return "log.id > :lowerBound and log.id <= :upperBound";
        }
        params.put("lastSuccessfulSyncDate", new Date(lowerBound));
        params.put("syncDate", new Date(upperBound));
        return "log.logDate >= :lastSuccessfulSyncDate and log.logDate < :syncDate";
    }

    protected FileSystemItemChange getFileSystemItemChange(CoreSession session, DocumentRef docRef, LogEntry entry, String expectedFileSystemItemId) throws ClientException {
        FileSystemItem fsItem;
        block7: {
            DocumentModel doc = session.getDocument(docRef);
            fsItem = null;
            try {
                fsItem = ((FileSystemItemAdapterService)Framework.getLocalService(FileSystemItemAdapterService.class)).getFileSystemItem(doc, false, false, false);
            }
            catch (RootlessItemException e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)String.format("RootlessItemException thrown while trying to adapt document %s as a FileSystemItem.", docRef));
            }
        }
        if (fsItem == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Document %s is not adaptable as a FileSystemItem, returning null.", docRef));
            }
            return null;
        }
        if (expectedFileSystemItemId != null && !fsItem.getId().endsWith("#" + expectedFileSystemItemId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Id %s of FileSystemItem adapted from document %s doesn't match expected FileSystemItem id %s, returning null.", fsItem.getId(), docRef, expectedFileSystemItemId));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Document %s is adaptable as a FileSystemItem, providing it to the FileSystemItemChange entry.", docRef));
        }
        return new FileSystemItemChangeImpl(entry.getEventId(), entry.getEventDate().getTime(), entry.getRepositoryId(), entry.getDocUUID(), fsItem);
    }
}

