/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.ui.tree;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.ui.tree.ContentProvider;
import org.nuxeo.ecm.webengine.ui.tree.JSonTreeSerializer;
import org.nuxeo.ecm.webengine.ui.tree.TreeItem;
import org.nuxeo.ecm.webengine.ui.tree.TreeModel;
import org.nuxeo.ecm.webengine.ui.tree.TreeModelImpl;

public abstract class JSonTree {
    protected TreeModelImpl tree;

    public TreeModel getTree() {
        return this.tree;
    }

    protected abstract Object getInput(WebContext var1);

    protected abstract ContentProvider getProvider(WebContext var1);

    protected abstract JSonTreeSerializer getSerializer(WebContext var1);

    public String updateSelection(WebContext ctx) {
        return this.updateSelection(ctx, this.getProvider(ctx), this.getSerializer(ctx));
    }

    public String enter(WebContext ctx, String path) {
        return this.enter(ctx, path, this.getSerializer(ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String updateSelection(WebContext ctx, ContentProvider provider, JSonTreeSerializer serializer) {
        try {
            FormData form;
            String selection;
            this.tree.setContentProvider(provider);
            if (!this.tree.hasInput()) {
                this.tree.setInput(this.getInput(ctx));
            }
            if ((selection = (form = ctx.getForm()).getString("root")) == null) {
                selection = form.getString("toggle");
                if (selection != null) {
                    this.toggle(selection);
                }
            } else {
                String result = null;
                result = "source".equals(selection) ? this.enter(ctx, this.tree.root.getPath().toString(), serializer) : this.enter(ctx, selection, serializer);
                if (result != null) {
                    String string = result;
                    return string;
                }
                ctx.getLog().warn((Object)("TreeItem: " + selection + " not found"));
            }
        }
        finally {
            this.tree.setContentProvider(null);
        }
        return null;
    }

    public String getTreeAsJSONArray(WebContext ctx) {
        JSonTreeSerializer serializer = this.getSerializer(ctx);
        JSONObject o = serializer.toJSON(this.tree.root);
        JSONArray array = new JSONArray();
        array.add((Object)o);
        return array.toString();
    }

    protected String enter(WebContext ctx, String path, JSonTreeSerializer serializer) {
        TreeItem item = this.tree.findAndReveal(path);
        if (item != null) {
            item.expand();
            JSONArray result = new JSONArray();
            if (item.isContainer()) {
                result = serializer.toJSON(item.getChildren());
            }
            return result.toString();
        }
        return null;
    }

    protected void toggle(String path) {
        TreeItem item = this.tree.findAndReveal(path);
        if (item.isExpanded()) {
            item.collapse();
        } else {
            item.expand();
        }
    }
}

