/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.model.relation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.query.helper.ToutaticeEsQueryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.osivia.procedures.record.model.RecordAnalyzer;
import org.osivia.procedures.record.security.rules.helper.RecordModelHelper;
import org.osivia.procedures.record.security.rules.helper.RelationModelHelper;
import org.osivia.procedures.record.security.rules.model.type.FieldType;

public class RelationsModelResolver {
    private static RelationsModelResolver instance;
    public static String SRC_RECORDS_QUERY;

    private RelationsModelResolver() {
    }

    public static synchronized RelationsModelResolver getInstance() {
        if (instance == null) {
            instance = new RelationsModelResolver();
        }
        return instance;
    }

    public boolean isSourceOfNToOneRelation(DocumentModel recordModel, String fieldDefName) {
        boolean isRecordType = false;
        if (recordModel != null) {
            ListProperty fieldsDefs = (ListProperty)recordModel.getProperty("pcd:globalVariablesDefinitions");
            Iterator iterator = fieldsDefs.iterator();
            while (iterator.hasNext() && !isRecordType) {
                MapProperty fieldDef = (MapProperty)iterator.next();
                if (!StringUtils.equals((String)fieldDefName, (String)((String)fieldDef.get("name").getValue(String.class)))) continue;
                String fieldDefType = (String)fieldDef.get("type").getValue(String.class);
                isRecordType = StringUtils.equals((String)fieldDefType, (String)FieldType.Record.getType());
            }
        }
        return isRecordType;
    }

    public String getTypeOfSourcesOfNToOneRelation(DocumentModel recordModel, String fieldDefName) {
        String type = null;
        ArrayList<Object> possibleTargetKeys = null;
        if (recordModel != null) {
            ListProperty fieldsDefs = (ListProperty)recordModel.getProperty("pcd:globalVariablesDefinitions");
            Iterator iteratorD = fieldsDefs.iterator();
            boolean isFieldList = false;
            while (iteratorD.hasNext() && !isFieldList) {
                MapProperty fieldDef = (MapProperty)iteratorD.next();
                if (!StringUtils.equals((String)fieldDefName, (String)((String)fieldDef.get("name").getValue(String.class)))) continue;
                String fieldDefType = (String)fieldDef.get("type").getValue(String.class);
                isFieldList = StringUtils.equals((String)fieldDefType, (String)"FIELDLIST");
            }
            if (isFieldList) {
                ListProperty fieldsRefs = (ListProperty)recordModel.getProperty("pcd:steps/0/globalVariablesReferences");
                Iterator iteratorR = fieldsRefs.iterator();
                String fieldPath = null;
                while (iteratorR.hasNext() && fieldPath == null) {
                    MapProperty fieldRef = (MapProperty)iteratorR.next();
                    if (!StringUtils.equals((String)fieldDefName, (String)((String)fieldRef.get("variableName").getValue(String.class)))) continue;
                    fieldPath = (String)fieldRef.get("path").getValue(String.class);
                }
                if (fieldPath != null) {
                    for (MapProperty fieldRef : fieldsRefs) {
                        String[] pathLevels;
                        String path = (String)fieldRef.get("path").getValue(String.class);
                        if (!StringUtils.contains((String)path, (String)fieldPath) || (pathLevels = StringUtils.split((String)path, (String)",")) == null || pathLevels.length <= 1) continue;
                        if (possibleTargetKeys == null) {
                            possibleTargetKeys = new ArrayList<Object>(1);
                        }
                        possibleTargetKeys.add(fieldRef.get("variableName").getValue(String.class));
                    }
                    if (possibleTargetKeys != null && possibleTargetKeys.size() > 0) {
                        Iterator it = possibleTargetKeys.iterator();
                        while (it.hasNext() && type == null) {
                            String possibleTgtKey = (String)it.next();
                            Iterator itD = fieldsDefs.iterator();
                            while (itD.hasNext() && type == null) {
                                String fieldDefType;
                                MapProperty fieldDef = (MapProperty)itD.next();
                                String fieldName = (String)fieldDef.get("name").getValue(String.class);
                                if (!StringUtils.equals((String)possibleTgtKey, (String)fieldName) || !StringUtils.equals((String)(fieldDefType = (String)fieldDef.get("type").getValue(String.class)), (String)FieldType.Record.getType())) continue;
                                String value = (String)fieldDef.get("varOptions").getValue(String.class);
                                try {
                                    JSONObject object = JSONObject.fromObject((Object)value);
                                    type = object.getString("recordFolderWebId");
                                }
                                catch (JSONException e) {
                                    type = null;
                                }
                            }
                        }
                    }
                }
            }
        }
        return type;
    }

    public DocumentModelList getSourcesOfRelationWithTarget(DocumentModel tgtRecord) {
        DocumentModelListImpl sources = null;
        DocumentModel tgtModel = RecordAnalyzer.getRecordModelOf(tgtRecord);
        if (tgtModel != null) {
            DocumentModelList srcModels = ToutaticeEsQueryHelper.unrestrictedQuery((CoreSession)tgtRecord.getCoreSession(), (String)RecordModelHelper.RECORD_MODELS_QUERY, (int)-1);
            String targetType = RecordModelHelper.getType(tgtModel);
            if (srcModels != null && srcModels.size() > 0) {
                for (DocumentModel srcModel : srcModels) {
                    ListProperty fieldsDefinitions = RecordModelHelper.getFieldsDefinitions(srcModel);
                    for (Property fieldDef : fieldsDefinitions) {
                        String srcPointingType;
                        MapProperty field = (MapProperty)fieldDef;
                        if (!StringUtils.equals((String)FieldType.Record.getType(), (String)((String)((Object)field.get("type").getValue()))) || !StringUtils.equals((String)(srcPointingType = RecordModelHelper.getModelType(field)), (String)targetType)) continue;
                        String targetKey = RelationsModelResolver.getTargetKey(srcModel, field);
                        String tgtWebId = (String)((Object)ToutaticeDocumentHelper.getUnrestrictedProperty((CoreSession)tgtRecord.getCoreSession(), (String)tgtRecord.getId(), (String)"ttc:webid"));
                        String query = String.format(SRC_RECORDS_QUERY, RecordModelHelper.getType(srcModel), targetKey, tgtWebId);
                        DocumentModelList sourcesRecords = ToutaticeEsQueryHelper.unrestrictedQuery((CoreSession)tgtRecord.getCoreSession(), (String)query, (int)-1);
                        if (!CollectionUtils.isNotEmpty((Collection)sourcesRecords)) continue;
                        if (sources == null) {
                            sources = new DocumentModelListImpl(sourcesRecords.size());
                        }
                        for (DocumentModel source : sourcesRecords) {
                            if (sources.contains((Object)source)) continue;
                            sources.add((Object)source);
                        }
                    }
                }
            }
        }
        return sources;
    }

    public static String getTargetKey(DocumentModel srcModel, MapProperty recordField) {
        String targetKey = (String)recordField.get("name").getValue(String.class);
        ListProperty references = (ListProperty)srcModel.getProperty("pcd:steps/0/globalVariablesReferences");
        String nToNBaseLevel = RelationModelHelper.getOneToNRelationIndicator(references, targetKey);
        if (StringUtils.isNotBlank((String)nToNBaseLevel)) {
            Iterator iterator = references.iterator();
            boolean parentFound = false;
            while (iterator.hasNext() && !parentFound) {
                MapProperty ref = (MapProperty)iterator.next();
                String path = (String)ref.get("path").getValue(String.class);
                if (!StringUtils.equals((String)nToNBaseLevel, (String)path)) continue;
                parentFound = true;
                targetKey = (String)ref.get("variableName").getValue(String.class);
            }
        }
        return targetKey;
    }

    public static String getOneToNRelationKey(DocumentModel srcModel, String targetKey) {
        String relationKey = "";
        ListProperty references = (ListProperty)srcModel.getProperty("pcd:steps/0/globalVariablesReferences");
        String nToNBaseLevel = RelationModelHelper.getOneToNRelationIndicator(references, targetKey);
        if (StringUtils.isNotBlank((String)nToNBaseLevel)) {
            Iterator iterator = references.iterator();
            boolean parentFound = false;
            while (iterator.hasNext() && !parentFound) {
                MapProperty ref = (MapProperty)iterator.next();
                String path = (String)ref.get("path").getValue(String.class);
                if (!StringUtils.equals((String)nToNBaseLevel, (String)path)) continue;
                parentFound = true;
                relationKey = (String)ref.get("variableName").getValue(String.class);
            }
        }
        return relationKey;
    }

    static {
        SRC_RECORDS_QUERY = "select * from Record where rcd:type = '%s' and rcd:data.%s.ttc:webid = '%s'  and ecm:isVersion = 0 and ecm:isProxy = 0 and ecm:currentLifeCycleState <> 'deleted' ";
    }
}

