/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.rules;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.osivia.procedures.record.security.rules.Context;
import org.osivia.procedures.record.security.rules.RecordsRelationFactory;
import org.osivia.procedures.record.security.rules.SecurityRelationsAdapter;
import org.osivia.procedures.record.security.rules.helper.RecordModelHelper;
import org.osivia.procedures.record.security.rules.helper.RelationModelHelper;
import org.osivia.procedures.record.security.rules.model.SecurityRelations;
import org.osivia.procedures.record.security.rules.model.relation.RecordsRelation;
import org.osivia.procedures.record.security.rules.model.relation.RelationModel;
import org.osivia.procedures.record.security.rules.model.relation.RelationModelType;
import org.osivia.procedures.record.security.rules.model.type.Entity;
import org.osivia.procedures.record.security.rules.model.type.FieldType;

public class RecordsRelationsResolver {
    public static final String LINKED_ONE_TO_N_ENTITIES_QUERY = "select * from Record where rcd:type = '%s' and ttc:webid in %s ";
    public static final String LINKED_ONE_TO_ONE_ENTITY_QUERY = "select * from Record where rcd:type = '%s' and rcd:data.%s = '%s' ";
    private static RecordsRelationsResolver instance;

    private RecordsRelationsResolver() {
    }

    public static synchronized RecordsRelationsResolver getInstance() {
        if (instance == null) {
            instance = new RecordsRelationsResolver();
        }
        return instance;
    }

    public SecurityRelations getInComingRelations(CoreSession session, DocumentModelList srcModels, Entity targetEntity, Map<String, Entity> treatedEntities, Set<RecordsRelation> treteadRelations) {
        SecurityRelations inComingRelations = new SecurityRelations();
        String targetType = targetEntity.getType();
        if (srcModels != null && srcModels.size() > 0) {
            for (DocumentModel srcModel : srcModels) {
                ListProperty fieldsDefinitions = RecordModelHelper.getFieldsDefinitions(srcModel);
                for (Property fieldDef : fieldsDefinitions) {
                    String srcPointingType;
                    MapProperty field = (MapProperty)fieldDef;
                    if (!StringUtils.equals((String)FieldType.Record.getType(), (String)((String)((Object)field.get("type").getValue()))) || !StringUtils.equals((String)(srcPointingType = RecordModelHelper.getModelType(field)), (String)targetType)) continue;
                    String targetKey = RelationModelHelper.getTargetKey(field);
                    RelationModelType relationType = RelationModelHelper.isOneToOneRelation(srcModel, targetKey) ? RelationModelType.oneToOne : RelationModelType.oneToN;
                    RelationModel relationModel = RelationModelHelper.buildModel(relationType, RecordModelHelper.getType(srcModel), RelationModelHelper.getTargetKey(relationType, srcModel, targetKey), targetType);
                    RecordsRelation relation = RecordsRelationFactory.getInstance(session).create(Context.inComingRelation, relationModel, srcModel, targetEntity, treatedEntities, treteadRelations);
                    if (relation == null) continue;
                    inComingRelations.add(SecurityRelationsAdapter.getInstance().adapt(session, Context.inComingRelation, relation));
                }
            }
        }
        return inComingRelations;
    }

    public SecurityRelations getOutComingRelations(CoreSession session, DocumentModelList targetModels, Entity srcEntity, Map<String, Entity> treatedEntities, Set<RecordsRelation> treteadRelations) {
        SecurityRelations outComingRelations = new SecurityRelations();
        DocumentModel srcModel = RecordModelHelper.getModelOf(targetModels, srcEntity);
        if (srcModel != null) {
            ListProperty fieldsDefs = RecordModelHelper.getFieldsDefinitions(srcModel);
            for (Property fieldDef : fieldsDefs) {
                MapProperty field = (MapProperty)fieldDef;
                if (!StringUtils.equals((String)FieldType.Record.getType(), (String)((String)((Object)field.get("type").getValue())))) continue;
                String srcPointingType = RecordModelHelper.getModelType(field);
                for (DocumentModel targetModel : targetModels) {
                    String targetType = (String)targetModel.getProperty("ttc:webid").getValue(String.class);
                    if (!StringUtils.equals((String)srcPointingType, (String)targetType)) continue;
                    String targetKey = RelationModelHelper.getTargetKey(field);
                    RelationModelType relationType = RelationModelHelper.isOneToOneRelation(srcModel, targetKey) ? RelationModelType.oneToOne : RelationModelType.oneToN;
                    RelationModel relationModel = RelationModelHelper.buildModel(relationType, RecordModelHelper.getType(srcModel), RelationModelHelper.getTargetKey(relationType, srcModel, targetKey), targetType);
                    RecordsRelation relation = RecordsRelationFactory.getInstance(session).create(Context.outComingRelation, relationModel, targetModel, srcEntity, treatedEntities, treteadRelations);
                    if (relation == null) continue;
                    outComingRelations.add(SecurityRelationsAdapter.getInstance().adapt(session, Context.outComingRelation, relation));
                }
            }
        }
        return outComingRelations;
    }
}

