/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.rules;

import fr.toutatice.ecm.platform.core.query.helper.ToutaticeEsQueryHelper;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.osivia.procedures.record.security.rules.helper.EntityHelper;
import org.osivia.procedures.record.security.rules.helper.RelationModelHelper;
import org.osivia.procedures.record.security.rules.model.relation.RelationModel;
import org.osivia.procedures.record.security.rules.model.relation.RelationModelType;
import org.osivia.procedures.record.security.rules.model.type.Entity;
import org.osivia.procedures.record.security.rules.model.type.FieldType;
import org.osivia.procedures.record.security.rules.model.type.RecordModel;

public class SecurityEntitiesResolver {
    private static final Log log = LogFactory.getLog(SecurityEntitiesResolver.class);
    public static final String SECURITY_ENTITIES_MODELS_QUERY = "select * from RecordFolder where pcd:globalVariablesDefinitions.type = 'PERSON' ";
    public static final String SECURITY_ENTITIES_OF_QUERY = "select * from Record where rcd:type = '%s' and rcd:data.%s = '%s'  and ecm:isVersion = 0 and ecm:isProxy = 0 and ecm:currentLifeCycleState <> 'deleted' ";
    private static SecurityEntitiesResolver instance;

    private SecurityEntitiesResolver() {
    }

    public static synchronized SecurityEntitiesResolver getInstance() {
        if (instance == null) {
            instance = new SecurityEntitiesResolver();
        }
        return instance;
    }

    public Map<String, Entity> getSecurityEntitiesOf(CoreSession session, Principal principal) {
        ConcurrentHashMap<String, Entity> entities = null;
        DocumentModelList securityModels = ToutaticeEsQueryHelper.query((CoreSession)session, (String)"select * from RecordFolder where pcd:globalVariablesDefinitions.type = 'PERSON'  and ecm:isVersion = 0 and ecm:isProxy = 0 and ecm:currentLifeCycleState <> 'deleted' ", (int)-1);
        for (DocumentModel securityModel : securityModels) {
            Set<RelationModel> usersRelation = this.getUsersRelations(securityModel);
            DocumentModelList securityRecords = this.getSecurityRecordsOf(session, usersRelation, principal);
            if (!CollectionUtils.isNotEmpty((Collection)securityRecords)) continue;
            Entity securityEntity = new Entity(EntityHelper.getType(securityModel));
            securityEntity.setRecordModel(new RecordModel(securityModel));
            securityEntity.setRecords((List<DocumentModel>)securityRecords);
            if (entities == null) {
                entities = new ConcurrentHashMap<String, Entity>();
            }
            entities.put(EntityHelper.getType(securityModel), securityEntity);
        }
        return entities;
    }

    private DocumentModelList getSecurityRecordsOf(CoreSession session, Set<RelationModel> relationsModels, Principal principal) {
        DocumentModelListImpl records = null;
        if (relationsModels != null) {
            for (RelationModel relationM : relationsModels) {
                String query = String.format(SECURITY_ENTITIES_OF_QUERY, relationM.getSourceType(), relationM.getTargetKey(), principal.getName());
                if (records == null) {
                    records = new DocumentModelListImpl();
                }
                records.addAll((Collection)ToutaticeEsQueryHelper.query((CoreSession)session, (String)query, (int)-1));
            }
        }
        return records;
    }

    private Set<RelationModel> getUsersRelations(DocumentModel securityModel) {
        HashSet<RelationModel> usersRelations = null;
        ListProperty fieldsDefinitions = (ListProperty)securityModel.getProperty("pcd:globalVariablesDefinitions");
        if (fieldsDefinitions != null) {
            for (Property fieldDefinition : fieldsDefinitions) {
                MapProperty fieldDef = (MapProperty)fieldDefinition;
                String fieldDefType = (String)fieldDef.get("type").getValue(String.class);
                if (!StringUtils.equals((String)FieldType.Person.getType(), (String)fieldDefType)) continue;
                RelationModel usrRelation = this.buildRelationModel(securityModel, fieldDef);
                if (usersRelations == null) {
                    usersRelations = new HashSet<RelationModel>(1);
                }
                usersRelations.add(usrRelation);
            }
        }
        return usersRelations;
    }

    private RelationModel buildRelationModel(DocumentModel model, MapProperty fieldDefinitionType) {
        RelationModel relationM = null;
        String fieldName = (String)fieldDefinitionType.get("name").getValue(String.class);
        if (RelationModelHelper.isOneToNRelation(model, fieldName)) {
            relationM = new RelationModel(RelationModelType.oneToN);
            relationM.setSourceType(EntityHelper.getType(model));
            relationM.setTargetKey(RelationModelHelper.getOneToNRelationKey(model, fieldName) + "/" + fieldName);
        } else if (RelationModelHelper.isOneToOneRelation(model, fieldName)) {
            relationM = new RelationModel(RelationModelType.oneToOne);
            relationM.setSourceType(EntityHelper.getType(model));
            relationM.setTargetKey(fieldName);
        }
        return relationM;
    }
}

