/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.api.scripting;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;

public class RoutingScriptingFunctions {
    private Log log = LogFactory.getLog(RoutingScriptingFunctions.class);
    public static final String BINDING_KEY = "WorkflowFn";
    protected GraphNode.EscalationRule rule;
    protected OperationContext ctx;

    public RoutingScriptingFunctions(OperationContext ctx) {
        this.ctx = ctx;
    }

    public RoutingScriptingFunctions(OperationContext ctx, GraphNode.EscalationRule rule) {
        this.ctx = ctx;
        this.rule = rule;
    }

    public long timeSinceWorkflowWasStarted() {
        return Calendar.getInstance().getTimeInMillis() - ((Calendar)this.ctx.get((Object)"workflowStartTime")).getTimeInMillis();
    }

    public long timeSinceTaskWasStarted() {
        return Calendar.getInstance().getTimeInMillis() - ((Calendar)this.ctx.get((Object)"nodeStartTime")).getTimeInMillis();
    }

    public long timeSinceDueDateIsOver() {
        return Calendar.getInstance().getTimeInMillis() - ((Calendar)this.ctx.get((Object)"taskDueTime")).getTimeInMillis();
    }

    public long timeSinceRuleHasBeenFalse() {
        if (this.rule == null) {
            throw new ClientRuntimeException("No escalation rule available in this context");
        }
        Calendar lastExecutionTime = this.rule.getLastExecutionTime();
        if (lastExecutionTime == null) {
            this.log.warn((Object)("Trying to evaluate timeSinceRuleHasBeenFalse() for the rule " + this.rule.getId() + " that hasn't been executed yet"));
            return -1L;
        }
        if (!this.rule.isExecuted()) {
            this.log.warn((Object)("Rule " + this.rule.getId() + " was never executed. Use with " + BINDING_KEY + " ruleAlreadyExecuted()."));
            return -1L;
        }
        return Calendar.getInstance().getTimeInMillis() - this.rule.getLastExecutionTime().getTimeInMillis();
    }

    public boolean ruleAlreadyExecuted() {
        if (this.rule == null) {
            throw new ClientRuntimeException("No escalation rule available in this context");
        }
        return this.rule.isExecuted();
    }
}

