/*
 * Decompiled with CFR 0.152.
 */
package fr.index.cloud.ens.community.es.customizer.writer.denormalization;

import fr.toutatice.ecm.es.customizer.writers.api.AbstractCustomJsonESWriter;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

public class FileDenormalizationWriter
extends AbstractCustomJsonESWriter {
    private static final Log log = LogFactory.getLog(FileDenormalizationWriter.class);
    private static final String SCHEMA = "mutualization";
    private static final String VIEWS_XPATH = "mtz:views";
    private static final String DOWNLOAD_XPATH = "mtz:downloads";
    private static final String VIEWS_DENORMALIZED_FIELD = "mtz:liveviews";
    private static final String DOWNLOAD_DENORMALIZED_FIELD = "mtz:livedownloads";

    public boolean accept(DocumentModel doc) {
        boolean accept = doc.hasSchema(SCHEMA) && doc.isProxy();
        return accept;
    }

    public void writeData(JsonGenerator jsonGenerator, DocumentModel document, String[] schemas, Map<String, String> contextParameters) throws IOException {
        DocumentModel liveDocument;
        DocumentModel sourceDocument = this.session.getSourceDocument(document.getRef());
        if (sourceDocument != null && (liveDocument = this.session.getDocument((DocumentRef)new PathRef(sourceDocument.getPath().toString()))) != null) {
            Long views = (Long)liveDocument.getPropertyValue(VIEWS_XPATH);
            jsonGenerator.writeNumberField(VIEWS_DENORMALIZED_FIELD, views.longValue());
            Long downloads = (Long)liveDocument.getPropertyValue(DOWNLOAD_XPATH);
            jsonGenerator.writeNumberField(DOWNLOAD_DENORMALIZED_FIELD, downloads.longValue());
            Map bmap = liveDocument.getBinaryFulltext();
            if (bmap != null && !bmap.isEmpty()) {
                for (Map.Entry item : bmap.entrySet()) {
                    String value = (String)item.getValue();
                    if (value == null) continue;
                    jsonGenerator.writeStringField("ecm:" + (String)item.getKey(), value);
                }
            }
        }
    }
}

