/*
 * Decompiled with CFR 0.152.
 */
package fr.index.cloud.ens.elasticsearch;

import fr.toutatice.ecm.es.customizer.writers.api.AbstractCustomJsonESWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public class CustomizedJsonESDocumentWriter
extends AbstractCustomJsonESWriter {
    private static final String SCHEMA = "indexClassifiers";
    private static final String LEVELS_XPATH = "idxcl:levels";
    private static final String LEVELS_DENORMALIZED_FIELD = "idxcl:levelsTree";
    private static final String LEVELS_VOCABULARY_NAME = "idx_level";
    private static final String SUBJECTS_XPATH = "idxcl:subjects";
    private static final String SUBJECTS_DENORMALIZED_FIELD = "idxcl:subjectsTree";
    private static final String SUBJECTS_VOCABULARY_NAME = "idx_subject";
    private static final String FILE_FORMAT_DENORMALIZED_FIELD = "idxcl:format";
    private static final String FILE_FORMAT_VOCABULARY_NAME = "idx_file_format";
    private static final String MIME_TYPE_VOCABULARY_NAME = "idx_mime_type_format";
    private static final String FILE_LABEL = "Fichier";
    private Map<String, Map<String, VocabularyEntry>> vocabularies;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public boolean accept(DocumentModel document) {
        return document.hasSchema(SCHEMA);
    }

    public void writeData(JsonGenerator jsonGenerator, DocumentModel document, String[] schemas, Map<String, String> contextParameters) throws IOException {
        this.writeTree(jsonGenerator, document, LEVELS_XPATH, LEVELS_DENORMALIZED_FIELD, LEVELS_VOCABULARY_NAME);
        this.writeTree(jsonGenerator, document, SUBJECTS_XPATH, SUBJECTS_DENORMALIZED_FIELD, SUBJECTS_VOCABULARY_NAME);
        this.writeFileFormat(jsonGenerator, document, FILE_FORMAT_DENORMALIZED_FIELD, MIME_TYPE_VOCABULARY_NAME, FILE_FORMAT_VOCABULARY_NAME);
    }

    private void writeFileFormat(JsonGenerator jsonGenerator, DocumentModel document, String denormalizedField, String mimeTypeVocabularyName, String formatVocabularyName) throws IOException {
        BlobHolder bHolder;
        String mimeType = null;
        String extension = null;
        if (document.hasSchema("file") && document != null && (bHolder = (BlobHolder)document.getAdapter(BlobHolder.class)) != null && bHolder.getBlob() != null) {
            mimeType = bHolder.getBlob().getMimeType();
            int iExtension = bHolder.getBlob().getFilename().lastIndexOf(46);
            if (iExtension != -1) {
                extension = bHolder.getBlob().getFilename().substring(iExtension + 1);
            }
        }
        if (StringUtils.isNotEmpty(mimeType)) {
            String fileFormat = null;
            Map<String, VocabularyEntry> mimeTypeVocabulary = this.getVocabulary(mimeTypeVocabularyName);
            if (MapUtils.isNotEmpty(mimeTypeVocabulary)) {
                VocabularyEntry entry = mimeTypeVocabulary.get(mimeType);
                if (entry != null) {
                    fileFormat = entry.getLabel();
                } else {
                    String type;
                    VocabularyEntry typeEntry;
                    int iSlash = mimeType.indexOf(47);
                    if (iSlash != -1 && (typeEntry = mimeTypeVocabulary.get(type = mimeType.substring(0, iSlash + 1))) != null) {
                        fileFormat = typeEntry.getLabel();
                    }
                }
            }
            String textDenormalization = null;
            if (StringUtils.isNotEmpty(fileFormat)) {
                VocabularyEntry entry;
                jsonGenerator.writeStringField(denormalizedField, fileFormat);
                Map<String, VocabularyEntry> formatVocabulary = this.getVocabulary(formatVocabularyName);
                if (MapUtils.isNotEmpty(formatVocabulary) && StringUtils.isNotEmpty((String)fileFormat) && (entry = formatVocabulary.get(fileFormat)) != null) {
                    String value;
                    textDenormalization = value = entry.getLabel();
                }
            }
            if (textDenormalization == null && StringUtils.isNotEmpty(extension)) {
                textDenormalization = "Fichier " + extension.toUpperCase();
            }
            if (textDenormalization == null) {
                textDenormalization = FILE_LABEL;
            }
            jsonGenerator.writeStringField(denormalizedField + "Text", textDenormalization);
        }
    }

    private void writeTree(JsonGenerator jsonGenerator, DocumentModel document, String xpath, String denormalizedField, String vocabularyName) throws IOException {
        Map<String, VocabularyEntry> vocabulary = this.getVocabulary(vocabularyName);
        Property property = document.getProperty(xpath);
        if (MapUtils.isNotEmpty(vocabulary) && property != null && property.isList()) {
            jsonGenerator.writeArrayFieldStart(denormalizedField);
            List values = (List)property.getValue(List.class);
            for (Object value : values) {
                ArrayList<String> tree = new ArrayList<String>();
                VocabularyEntry entry = vocabulary.get(value);
                while (entry != null) {
                    tree.add(0, entry.getId());
                    if (StringUtils.isEmpty((String)entry.getParent())) {
                        entry = null;
                        continue;
                    }
                    entry = vocabulary.get(entry.getParent());
                }
                if (!CollectionUtils.isNotEmpty(tree)) continue;
                jsonGenerator.writeString(StringUtils.join(tree, (String)"/"));
            }
            jsonGenerator.writeEndArray();
        }
    }

    private Map<String, VocabularyEntry> getVocabulary(String vocabularyName) {
        if (this.vocabularies == null) {
            this.initializeVocabularies();
        }
        return this.vocabularies.get(vocabularyName);
    }

    private synchronized void initializeVocabularies() {
        if (this.vocabularies == null) {
            DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
            String[] vocabularyNames = new String[]{LEVELS_VOCABULARY_NAME, SUBJECTS_VOCABULARY_NAME, FILE_FORMAT_VOCABULARY_NAME, MIME_TYPE_VOCABULARY_NAME};
            this.vocabularies = new ConcurrentHashMap<String, Map<String, VocabularyEntry>>(vocabularyNames.length);
            for (String vocabularyName : vocabularyNames) {
                this.initializeVocabulary(directoryService, vocabularyName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeVocabulary(DirectoryService directoryService, String vocabularyName) {
        String schema = directoryService.getDirectorySchema(vocabularyName);
        Session directorySession = null;
        try {
            ConcurrentHashMap<String, VocabularyEntry> vocabulary;
            directorySession = directoryService.open(vocabularyName);
            HashMap filter = new HashMap(0);
            DocumentModelList documents = directorySession.query(filter);
            if (CollectionUtils.isEmpty((Collection)documents)) {
                vocabulary = new ConcurrentHashMap<String, VocabularyEntry>(0);
            } else {
                vocabulary = new ConcurrentHashMap(documents.size());
                for (DocumentModel document : documents) {
                    String id = (String)document.getProperty(schema, "id");
                    String parent = (String)document.getProperty(schema, "parent");
                    String label = (String)document.getProperty(schema, "label");
                    if (!StringUtils.isNotEmpty((String)id)) continue;
                    VocabularyEntry entry = new VocabularyEntry();
                    entry.setId(id);
                    entry.setParent(parent);
                    entry.setLabel(label);
                    vocabulary.put(id, entry);
                }
            }
            this.vocabularies.put(vocabularyName, vocabulary);
        }
        catch (DirectoryException e) {
            this.log.error((Object)e.getMessage(), e.getCause());
        }
        finally {
            if (directoryService != null) {
                try {
                    directorySession.close();
                }
                catch (DirectoryException e) {
                    this.log.error((Object)e.getMessage(), e.getCause());
                }
            }
        }
    }

    private class VocabularyEntry {
        private String id;
        private String label;
        private String parent;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParent() {
            return this.parent;
        }

        public void setParent(String parent) {
            this.parent = parent;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }
}

