/*
 * Decompiled with CFR 0.152.
 */
package fr.index.cloud.ens.statistics.operation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.Property;

public class UpdateDocumentStatisticsRunner
extends ToutaticeSilentProcessRunnerHelper {
    private static final String WEBID_XPATH = "ttc:webid";
    private static final String VIEWS_XPATH = "mtz:views";
    private static final String DOWNLOADS_XPATH = "mtz:downloads";
    private final DocumentModel document;
    private final boolean incrementsViews;
    private final boolean incrementsDownloads;
    private final Log log;

    public UpdateDocumentStatisticsRunner(CoreSession session, DocumentModel document, boolean incrementsViews, boolean incrementsDownloads) {
        super(session);
        this.document = document;
        this.incrementsViews = incrementsViews;
        this.incrementsDownloads = incrementsDownloads;
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    public void run() throws ClientException {
        String query;
        DocumentModelList results;
        String webId = (String)this.document.getProperty(WEBID_XPATH).getValue(String.class);
        Object live = this.document.isProxy() ? ((results = this.session.query(query = "SELECT * FROM Document WHERE ecm:isProxy = 0 AND ecm:isVersion = 0 AND ttc:webid = '" + webId + "'")).isEmpty() ? null : (DocumentModel)results.get(0)) : this.document;
        if (live == null) {
            this.log.error((Object)("Unable to find live document for webId: '" + webId + "'."));
        } else {
            if (this.incrementsViews) {
                this.increments((DocumentModel)live, VIEWS_XPATH);
            }
            if (this.incrementsDownloads) {
                this.increments((DocumentModel)live, DOWNLOADS_XPATH);
            }
            this.session.saveDocument(live);
        }
    }

    private void increments(DocumentModel live, String xpath) {
        Property property = live.getProperty(xpath);
        Integer value = (Integer)property.getValue(Integer.class);
        try {
            DocumentHelper.setProperty((CoreSession)this.session, (DocumentModel)live, (String)xpath, (String)String.valueOf(value + 1));
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
    }
}

