/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.resource;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.java.dev.webdav.jaxrs.methods.PROPFIND;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.webdav.backend.Backend;
import org.nuxeo.ecm.webdav.backend.BackendHelper;
import org.nuxeo.ecm.webdav.resource.FileResource;
import org.nuxeo.ecm.webdav.resource.FolderResource;
import org.nuxeo.ecm.webdav.resource.UnknownResource;
import org.nuxeo.ecm.webdav.resource.VirtualFolderResource;

@Path(value="")
public class RootResource {
    private static final Log log = LogFactory.getLog(RootResource.class);
    private HttpServletRequest request;

    public RootResource(@Context HttpServletRequest request) throws Exception {
        log.debug((Object)(request.getMethod() + " " + request.getRequestURI()));
        this.request = request;
    }

    @GET
    @Produces(value={"text/html"})
    public Object getRoot() throws Exception {
        Object resource = this.findResource("");
        if (resource instanceof FolderResource) {
            return ((FolderResource)resource).get();
        }
        return ((VirtualFolderResource)this.findResource("")).get();
    }

    @OPTIONS
    public Object getRootOptions() throws Exception {
        Object resource = this.findResource("");
        if (resource instanceof FolderResource) {
            return ((FolderResource)resource).options();
        }
        return ((VirtualFolderResource)this.findResource("")).options();
    }

    @PROPFIND
    public Object getRootPropfind(@Context UriInfo uriInfo, @HeaderParam(value="depth") String depth) throws Exception {
        Object resource = this.findResource("");
        if (resource instanceof FolderResource) {
            return ((FolderResource)resource).propfind(uriInfo, depth);
        }
        return ((VirtualFolderResource)this.findResource("")).propfind(uriInfo, depth);
    }

    @Path(value="{path:.+}")
    public Object findResource(@PathParam(value="path") String path) throws Exception {
        Backend backend = BackendHelper.getBackend(path = new String(path.getBytes(), "UTF-8"), this.request);
        if (backend == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (backend.isVirtual()) {
            return new VirtualFolderResource(path, this.request, backend.getVirtualFolderNames());
        }
        DocumentModel doc = null;
        try {
            doc = backend.getDocument(path);
        }
        catch (Exception e) {
            log.error((Object)("Error during resolving path: " + path), (Throwable)e);
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        if (doc == null) {
            return new UnknownResource(path, this.request, backend);
        }
        if (!backend.hasPermission(doc.getRef(), "Read")) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (doc.isFolder()) {
            return new FolderResource(this.getDocumentPath(doc), doc, this.request, backend);
        }
        return new FileResource(this.getDocumentPath(doc), doc, this.request, backend);
    }

    private String getDocumentPath(DocumentModel source) throws ClientException {
        Blob blob;
        if (source.isFolder()) {
            return source.getPathAsString();
        }
        BlobHolder bh = (BlobHolder)source.getAdapter(BlobHolder.class);
        if (bh != null && (blob = bh.getBlob()) != null) {
            return blob.getFilename();
        }
        return String.valueOf(source.getPropertyValue("dc:title"));
    }
}

