/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.views;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.platform.rendering.api.ResourceLocator;
import org.nuxeo.ecm.platform.rendering.fm.FreemarkerEngine;
import org.nuxeo.ecm.webengine.jaxrs.views.ViewNotFoundException;
import org.osgi.framework.Bundle;

public class TemplateView {
    private static final FreemarkerEngine engine = new FreemarkerEngine(null, (ResourceLocator)new Locator());
    private static final Map<String, TemplateView> locators = new HashMap<String, TemplateView>();
    protected Object owner;
    protected final URL url;
    protected final Map<String, Object> vars = new HashMap<String, Object>();

    public static URL resolveFile(File file) throws ViewNotFoundException {
        if (!file.isFile()) {
            throw new ViewNotFoundException(null, null, file.getAbsolutePath());
        }
        try {
            return file.toURI().toURL();
        }
        catch (Exception e) {
            throw new ViewNotFoundException(e, null, file.getAbsolutePath());
        }
    }

    public static URL resolveResource(Object owner, String name) throws ViewNotFoundException {
        URL url = owner.getClass().getResource(name);
        if (url == null) {
            throw new ViewNotFoundException(null, owner, name);
        }
        return url;
    }

    public static URL resolveResourceFromBundle(Bundle bundle, String name) throws ViewNotFoundException {
        URL url = bundle.getEntry(name);
        if (url == null) {
            throw new ViewNotFoundException(null, bundle, name);
        }
        return url;
    }

    private static URL resolveResource(Bundle bundle, Object owner, String name) throws ViewNotFoundException {
        return bundle != null ? TemplateView.resolveResourceFromBundle(bundle, name) : TemplateView.resolveResource(owner, name);
    }

    public TemplateView(String name) {
        this(null, null, name);
    }

    public TemplateView(Object owner, String name) {
        this(null, owner, name);
    }

    public TemplateView(Bundle bundle, Object owner, String name) {
        this(owner, TemplateView.resolveResource(bundle, owner, name));
    }

    public TemplateView(File file) {
        this(null, file);
    }

    public TemplateView(Object owner, File file) {
        this(owner, TemplateView.resolveFile(file));
    }

    public TemplateView(URL url) {
        this(null, url);
    }

    public TemplateView(Object owner, URL url) {
        this.url = url;
        if (owner != null) {
            this.forObject(owner);
        }
    }

    public TemplateView forObject(Object owner) {
        this.owner = owner;
        this.vars.put("This", owner);
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public Object getOwner() {
        return this.owner;
    }

    public TemplateView arg(String key, Object value) {
        this.vars.put(key, value);
        return this;
    }

    public void render(Writer writer) throws Exception {
        String id = TemplateView.addLocator(this);
        try {
            engine.render(id, this.vars, writer);
            writer.flush();
        }
        finally {
            TemplateView.removeLocator(id);
        }
    }

    public void render(OutputStream out) throws Exception {
        this.render(new OutputStreamWriter(out, "UTF-8"));
    }

    private static synchronized String addLocator(TemplateView view) {
        String locatorId = "view:/" + view.getUrl().toExternalForm();
        locators.put(locatorId, view);
        return locatorId;
    }

    private static synchronized void removeLocator(String id) {
        locators.remove(id);
    }

    private static synchronized TemplateView getLocator(String id) {
        return locators.get(id);
    }

    static class Locator
    implements ResourceLocator {
        Locator() {
        }

        public File getResourceFile(String key) {
            return null;
        }

        public URL getResourceURL(String key) {
            TemplateView view = TemplateView.getLocator(key);
            if (view != null) {
                return view.getUrl();
            }
            return null;
        }
    }
}

