/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.IOException;
import org.jrobin.core.jrrd.Constants;
import org.jrobin.core.jrrd.RRDFile;

public class Header
implements Constants {
    static final long offset = 0L;
    long size;
    String version;
    int dsCount;
    int rraCount;
    int pdpStep;

    Header(RRDFile file) throws IOException {
        if (!file.readString(4).equals("RRD")) {
            throw new IOException("Invalid COOKIE");
        }
        this.version = file.readString(5);
        if (!this.version.equals("0001")) {
            throw new IOException("Unsupported RRD version (" + this.version + ")");
        }
        file.align();
        file.readDouble();
        this.dsCount = file.readInt();
        this.rraCount = file.readInt();
        this.pdpStep = file.readInt();
        file.align();
        file.skipBytes(80);
        this.size = file.getFilePointer() - 0L;
    }

    public String getVersion() {
        return this.version;
    }

    public int getDSCount() {
        return this.dsCount;
    }

    public int getRRACount() {
        return this.rraCount;
    }

    public int getPDPStep() {
        return this.pdpStep;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[Header: OFFSET=0x00, SIZE=0x");
        sb.append(Long.toHexString(this.size));
        sb.append(", version=");
        sb.append(this.version);
        sb.append(", dsCount=");
        sb.append(this.dsCount);
        sb.append(", rraCount=");
        sb.append(this.rraCount);
        sb.append(", pdpStep=");
        sb.append(this.pdpStep);
        sb.append("]");
        return sb.toString();
    }
}

