/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;

public class UTF8CharsetConverter
implements Converter {
    public void init(ConverterDescriptor descriptor) {
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        Blob transcodedBlob;
        String path;
        Blob originalBlob;
        try {
            originalBlob = blobHolder.getBlob();
            path = blobHolder.getFilePath();
        }
        catch (ClientException e) {
            throw new ConversionException("Cannot fetch content of blob", (Exception)((Object)e));
        }
        try {
            transcodedBlob = this.convert(originalBlob);
        }
        catch (IOException e) {
            throw new ConversionException("Cannot transcode " + path + " to UTF-8", (Exception)e);
        }
        return new SimpleBlobHolder(transcodedBlob);
    }

    protected Blob convert(Blob blob) throws IOException, ConversionException {
        InputStreamBlob newBlob;
        String mimetype = blob.getMimeType();
        if (mimetype == null || !mimetype.startsWith("text/")) {
            return blob;
        }
        String encoding = blob.getEncoding();
        if (encoding != null && "UTF-8".equals(encoding)) {
            return blob;
        }
        BufferedInputStream in = new BufferedInputStream(blob.getStream());
        String filename = blob.getFilename();
        if (encoding == null || encoding.length() == 0) {
            encoding = this.detectEncoding(in);
        }
        if ("UTF-8".equals(encoding)) {
            newBlob = new InputStreamBlob((InputStream)in);
        } else {
            String content = IOUtils.toString((InputStream)in, (String)encoding);
            newBlob = new StringBlob(content);
        }
        newBlob.setMimeType(mimetype);
        newBlob.setEncoding("UTF-8");
        newBlob.setFilename(filename);
        return newBlob;
    }

    protected String detectEncoding(InputStream in) throws IOException, ConversionException {
        CharsetDetector detector = new CharsetDetector();
        detector.setText(in);
        CharsetMatch charsetMatch = detector.detect();
        if (charsetMatch == null) {
            throw new ConversionException("Cannot detect source charset.");
        }
        return charsetMatch.getName();
    }
}

