/*
 * (C) Copyright 2014 Académie de Rennes (http://www.ac-rennes.fr/) and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 *
 * Contributors:
 *  aguihomat
 *
 *
 */
package fr.toutatice.cartographie.portail.cartographie;



import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;

import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

import fr.toutatice.cartographie.portail.cartographie.beans.FormAdmin;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;

@Controller
@RequestMapping("ADMIN")

public class AdminController extends CMSPortlet implements PortletContextAware, PortletConfigAware{

	private PortletContext portletContext;
	private PortletConfig portletConfig;

	@Autowired
	@Qualifier("adminValidator")
	private Validator adminValidator;


	@RequestMapping
    public String showAdmin(final ModelMap model, RenderRequest request, PortletSession session) {
		final PortalWindow window = WindowFactory.getWindow(request);
		final FormAdmin formulaire = new FormAdmin();

		if(window.getProperty("toutatice.cartographie.latitudeRef")!=null){
			formulaire.setLatitudeRef(window.getProperty("toutatice.cartographie.latitudeRef"));
		}
		if(window.getProperty("toutatice.cartographie.longitudeRef")!=null){
			formulaire.setLongitudeRef(window.getProperty("toutatice.cartographie.longitudeRef"));
		}
		if(window.getProperty("toutatice.cartographie.zoomRef")!=null){
			formulaire.setZoomRef(window.getProperty("toutatice.cartographie.zoomRef"));
		}
		if(window.getProperty("toutatice.cartographie.zoomMax")!=null){
			formulaire.setZoomMax(window.getProperty("toutatice.cartographie.zoomMax"));
		}
		if(window.getProperty("toutatice.cartographie.zoomMin")!=null){
			formulaire.setZoomMin(window.getProperty("toutatice.cartographie.zoomMin"));
		}
		if(window.getProperty("toutatice.cartographie.maxBoundsSouthWest")!=null){
			formulaire.setMaxBoundsSouthWest(window.getProperty("toutatice.cartographie.maxBoundsSouthWest"));
		}
		if(window.getProperty("toutatice.cartographie.maxBoundsNorthEast")!=null){
			formulaire.setMaxBoundsNorthEast(window.getProperty("toutatice.cartographie.maxBoundsNorthEast"));
		}
		if(window.getProperty("toutatice.cartographie.fitbounds")!=null){
			formulaire.setFitbounds(Boolean.parseBoolean(window.getProperty("toutatice.cartographie.fitbounds")));
		}
		if(window.getProperty("toutatice.cartographie.fluxgeojsonAdmin")!=null){
			formulaire.setFluxJsonAdmin(window.getProperty("toutatice.cartographie.fluxgeojsonAdmin"));
		}
		if(window.getProperty("toutatice.cartographie.listefluxgeojson")!=null){
			formulaire.setListeFluxJson(window.getProperty("toutatice.cartographie.listefluxgeojson"));
		}

		model.addAttribute("formulaire",formulaire);

		return "admin";
	}


	@ActionMapping(params="action=setAdminProperty")
	public void setAdminProperty(@ModelAttribute FormAdmin formulaire, BindingResult result, ActionRequest request, ActionResponse response, ModelMap modelMap, PortletSession session, final ModelMap model) throws Exception  {

		adminValidator.validate(formulaire, result);
		//TODO : intégrer un validator JSON
		if (!result.hasErrors()) {

			final PortalWindow window = WindowFactory.getWindow(request);
			window.setProperty("toutatice.cartographie.latitudeRef", formulaire.getLatitudeRef());
			window.setProperty("toutatice.cartographie.longitudeRef", formulaire.getLongitudeRef());
			window.setProperty("toutatice.cartographie.zoomRef", formulaire.getZoomRef());
			window.setProperty("toutatice.cartographie.zoomMax", formulaire.getZoomMax());
			window.setProperty("toutatice.cartographie.zoomMin", formulaire.getZoomMin());
			window.setProperty("toutatice.cartographie.maxBoundsSouthWest", formulaire.getMaxBoundsSouthWest());
			window.setProperty("toutatice.cartographie.maxBoundsNorthEast", formulaire.getMaxBoundsNorthEast());
			window.setProperty("toutatice.cartographie.fitbounds", Boolean.toString(formulaire.isFitbounds()));
			window.setProperty("toutatice.cartographie.fluxgeojsonAdmin", formulaire.getFluxJsonAdmin());
			window.setProperty("toutatice.cartographie.listefluxgeojson", formulaire.getListeFluxJson());
			response.setPortletMode(PortletMode.VIEW);

		}else{
			response.setPortletMode(PortletMode.EDIT);
		}



	}

	@ActionMapping(params="action=annuler")
	public void annuler(ActionRequest request, ActionResponse response) throws Exception  {

		response.setPortletMode(PortletMode.VIEW);
		response.setRenderParameter("action", "");
	}




	@Override
    public void setPortletConfig(PortletConfig portletConfig) {
		this.portletConfig = portletConfig;
	}
	@Override
    public void setPortletContext(PortletContext ctx) {
		portletContext = ctx;
	}

}
