<%@ page contentType="text/plain; charset=UTF-8"%>
<%@ include file="/WEB-INF/jsp/include.jsp"%>


<portlet:defineObjects />
  
  <head>
    <meta name="viewport" content="initial-scale=1.0, user-scalable=no" />
 
    
    
     <script type="text/javascript" language="javascript">
     
     	  var map;
     	  
     	   window.onload = function() {
		     
		     <%
             String fluxGeoJson = (String) request.getAttribute("fluxGeoJson");
             %>
		     
		     
			map = L.map('map-carto');
		     
		     var tileLayer = new L.tileLayer('http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
   				attribution: 'Map data &copy;',
				});
				tileLayer.addTo(map);
		     
		     
		      //Extend the Default marker class
		         var RedIcon = L.Icon.Default.extend({
		            options: {
		            	    iconUrl: '<%=request.getContextPath()%>/images/marker-red.png'
		            }
		         });
		         
		          var BlueIcon = L.Icon.Default.extend({
		            options: {
		            	    iconUrl: '<%=request.getContextPath()%>/images/marker-blue.png'
		            }
		         });
		         
		          var GreenIcon = L.Icon.Default.extend({
		            options: {
		            	    iconUrl: '<%=request.getContextPath()%>/images/marker-green.png'
		            }
		         });
		         
		          var OrangeIcon = L.Icon.Default.extend({
		            options: {
		            	    iconUrl: '<%=request.getContextPath()%>/images/marker-orange.png'
		            }
		         });
		         
		          var YellowIcon = L.Icon.Default.extend({
		            options: {
		            	    iconUrl: '<%=request.getContextPath()%>/images/marker-yellow.png'
		            }
		         });
		         
		         var PurpleIcon = L.Icon.Default.extend({
		            options: {
		            	    iconUrl: '<%=request.getContextPath()%>/images/marker-purple.png'
		            }
		         });
		         
		         function makeGroup(color) {
				    return new L.MarkerClusterGroup({
				    	spiderfyOnMaxZoom: true, 
				    	showCoverageOnHover: true, 
				    	zoomToBoundsOnClick: true,
				        iconCreateFunction: function(cluster) {
				          return new L.DivIcon({
				            iconSize: [20, 20],
				            html: '<div style="text-align:center;color:#fff;background:' +
				            color + '">' + cluster.getChildCount() + '</div>'
				          });
				        }
			      	}).addTo(map);
			    }
			    
			    
		         
					        
	
			
			<%if (! fluxGeoJson.trim().isEmpty() && !fluxGeoJson.equals("[]")){	%>	
			
			var markers = new L.MarkerClusterGroup({ spiderfyOnMaxZoom: true, showCoverageOnHover: true, zoomToBoundsOnClick: true }); 
			var markersFitBounds = new L.MarkerClusterGroup({ spiderfyOnMaxZoom: true, showCoverageOnHover: true, zoomToBoundsOnClick: true }); 
			
			var clusterred = new L.MarkerClusterGroup({
				        iconCreateFunction: function(cluster) {
				          return new L.DivIcon({
				            iconSize: [20, 20],
				            html: '<div style="text-align:center;color:#fff;background:red">' + cluster.getChildCount() + '</div>'
				          });
				        }
			      	});
			  var clusterblue = new L.MarkerClusterGroup({
				        iconCreateFunction: function(cluster) {
				        	return new L.DivIcon({ html: '<div><span><b>' + cluster.getChildCount() + '</b></span></div>', className: 'marker-cluster-blue', iconSize: new L.Point(30, 30) });
				          
				        }
				       
			    });     	
			
	      	 var clusterorange = new L.MarkerClusterGroup({
				           iconCreateFunction: function(cluster) {
				        	return new L.DivIcon({ html: '<div><span><b>' + cluster.getChildCount() + '</b></span></div>', className: 'marker-cluster-orange', iconSize: new L.Point(30, 30) });
				          
				        }
			      	});
			      	
			 var clustergreen = new L.MarkerClusterGroup({
				        iconCreateFunction: function(cluster) {
				          return new L.DivIcon({
				            iconSize: [20, 20],
				            html: '<div style="text-align:center;color:#fff;background:green">' + cluster.getChildCount() + '</div>'
				          });
				        }
			      	});   
			      	
			      	var clusterpurple = new L.MarkerClusterGroup({
				        iconCreateFunction: function(cluster) {
				          return new L.DivIcon({
				            iconSize: [20, 20],
				            html: '<div style="text-align:center;color:#fff;background:purple">' + cluster.getChildCount() + '</div>'
				          });
				        }
			      	});  
			      	
			      	var clusteryellow = new L.MarkerClusterGroup({
				        iconCreateFunction: function(cluster) {
				          return new L.DivIcon({
				            iconSize: [20, 20],
				            html: '<div style="text-align:center;color:#fff;background:yellow">' + cluster.getChildCount() + '</div>'
				          });
				        }
			      	});      	
				
				var geoJsonLayer = L.geoJson(<%=fluxGeoJson%>, {
				
					pointToLayer: function(feature, latlng) {
					
						if(feature.properties.image){
							
							var customIcon = new L.Icon({
	                   
	                        	iconUrl: '<%=request.getContextPath()%>/images/'+feature.properties.image
                    });
                   
                    return L.marker(latlng, {icon: customIcon});
                    
						
						}else{
							if(feature.properties.couleur){
								
								if(feature.properties.couleur=='red'){
		                    		return L.marker(latlng, {icon: new RedIcon()});
		                    	}else{
			                    	if(feature.properties.couleur=='green'){
			                    		return L.marker(latlng, {icon: new GreenIcon()});
			                    	}else{
			                    		if(feature.properties.couleur=='orange'){
				                    		return L.marker(latlng, {icon: new OrangeIcon()});
				                    	}else{
				                    		if(feature.properties.couleur=='yellow'){
					                    		return L.marker(latlng, {icon: new YellowIcon()});
					                    	}else{
					                    		if(feature.properties.couleur=='purple'){
					                    			return L.marker(latlng, {icon: new PurpleIcon()});
						                    	}else{
					                    			return L.marker(latlng, {icon: new BlueIcon()});
					                    		}
				                    		}
			                    		}
		                    		}
		                    	}
	                    	
	                    	}else{
	                    		return L.marker(latlng, {icon: new BlueIcon()});
	                    	}
	                    }
                    	
            		},
            		
            		
			   		
			   
				
					onEachFeature: function (feature, layer) {
						if (feature.properties && feature.properties.popupContent) {
					        layer.bindPopup(feature.properties.popupContent);
					    }
					    if(feature.properties && feature.properties.couleurcluster){
								
								if(feature.properties.couleurcluster=='red'){
		                    		clustered.addLayer(layer);
		                    	}else{
			                    	if(feature.properties.couleurcluster=='green'){
			                    		clustergreen.addLayer(layer);
			                    	}else{
			                    		if(feature.properties.couleurcluster=='orange'){
				                    		clusterorange.addLayer(layer);
				                    	}else{
				                    		if(feature.properties.couleurcluster=='yellow'){
					                    		clusteryellow.addLayer(layer);
					                    	}else{
					                    		if(feature.properties.couleurcluster=='purple'){
					                    			clusterpurple.addLayer(layer);
						                    	}else{
					                    			clusterblue.addLayer(layer);
					                    		}
				                    		}
			                    		}
		                    		}
		                    	}
	                    	
	                    	}else{
	                    		markers.addLayer(layer);
	                    	}
					  
					  		markersFitBounds.addLayer(layer);	
						
						
					}
				});
				
				map.addLayer(clusterorange);
				map.addLayer(clusterblue);
				map.addLayer(clusterred);
				map.addLayer(clusteryellow);
				map.addLayer(clustergreen);
				map.addLayer(clusterpurple);
				map.addLayer(markers);
				
				map.on("dragend",function(ev){
					document.getElementById("toTop").className = "visible-xs-block";
		        });
				
				map.fitBounds(markersFitBounds.getBounds(), {padding: [15, 15]});  
				<%
				
			}else{%>
				map.fitWorld().zoomIn();
			<%}%>
			
		  }   
      </script>
   
   
  </head>
  
  
  
 <body> 
 
  	<input type="hidden" name="cartoHidden" id="cartoHidden" size="1" />
 
    <div id="map-carto"> </div>
 
 	<p><op:translate key="label.credits" /></p>
 	
 	<a id="toTop" class="hidden" href="#listeactivites" onclick="this.className='hidden';">
 		<i class="glyphicons glyphicons-chevron-left rotate90"></i>
	</a>
 
  </body>
