package fr.toutatice.cartoun.customizer.attributes;

import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;

import org.apache.commons.lang.StringUtils;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.theme.PageRendition;
import org.jboss.portal.security.impl.jacc.JACCPortalPrincipal;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.theming.IAttributesBundle;
import org.osivia.portal.api.urls.IPortalUrlFactory;


public class CustomToolbarAttributesBundle implements IAttributesBundle {

    /** DISCIPLINES_PAGE_URL */
    private final static String DISCIPLINES_PAGE_URL = "acrennes.sites.cartoun.disciplinesPage.url";

    private final static String FICHE_PROFIL_PAGE_URL = "acrennes.sites.cartoun.ficheProfilPage.url";

    private final static String FICHE_PERSONNE_PAGE_URL = "acrennes.sites.cartoun.fichePersonnePage.url";

    private static final String IPR = "_IPR";

    private static final String ENSPUBLIC = "_EnsPublic";

    private static final String ENSPRIVE = "_EnsPrive";

    /** Portal URL factory. */
    private final IPortalUrlFactory urlFactory;
    /** Toolbar attributes names. */
    private final Set<String> names;

    /** directoryServiceLocator */
    private final IDirectoryServiceLocator directoryServiceLocator;

    /**
     * Singleton Holder
     */
    private static class CustomToolbarAttributesBundleHolder {

        private static final CustomToolbarAttributesBundle INSTANCE = new CustomToolbarAttributesBundle();
    }

    /**
     * Singleton instance access.
     *
     * @return singleton instance
     */
    public static CustomToolbarAttributesBundle getInstance() {
        return CustomToolbarAttributesBundleHolder.INSTANCE;
    }

    /**
     * Constructor
     */
    private CustomToolbarAttributesBundle() {
        // URL factory
        urlFactory = Locator.findMBean(IPortalUrlFactory.class, IPortalUrlFactory.MBEAN_NAME);
        names = new TreeSet<String>();
        names.add(DISCIPLINES_PAGE_URL);
        names.add(FICHE_PROFIL_PAGE_URL);
        names.add(FICHE_PERSONNE_PAGE_URL);

        this.directoryServiceLocator = Locator.findMBean(IDirectoryServiceLocator.class, IDirectoryServiceLocator.MBEAN_NAME);
    }

    @Override
    public void fill(RenderPageCommand renderPageCommand, PageRendition pageRendition, Map<String, Object> attributes) throws ControllerException {
        final ControllerContext controllerContext = renderPageCommand.getControllerContext();
        final PortalControllerContext portalControllerContext = new PortalControllerContext(controllerContext);

        // Get the current authenticated subject through the JACC
        // contract
        Subject subject;
        try {
            subject = (Subject) PolicyContext.getContext("javax.security.auth.Subject.container");
        } catch (PolicyContextException e) {
            throw new ControllerException(e);
        }

        // utilisation mapping standard du portail
        JACCPortalPrincipal pp = new JACCPortalPrincipal(subject);
        String disciplinePageUrl = null;
        String ficheProfilPageUrl = null;
        String fichePersonnePageUrl = null;
        try {
            final Map<String, String> map = new HashMap<String, String>();
            fichePersonnePageUrl = urlFactory.getStartPortletInNewPage(portalControllerContext, "Mon Profil", "Mon Profil",
                    "toutatice-identite-fichepersonne-portailPortletInstance", map, map);
            Iterator iter = pp.getRoles().iterator();
            while (iter.hasNext()) {
                Principal principal = (Principal) iter.next();
                if ((ficheProfilPageUrl == null) && (principal.getName().endsWith(IPR) || StringUtils.equals(principal.getName(), "Administrators"))) {
                    disciplinePageUrl = urlFactory.getStartPageUrl(portalControllerContext, "Mes Disciplines", "/cartoun/templates/disciplines", map, map);
                    ficheProfilPageUrl = urlFactory.getStartPageUrl(portalControllerContext, "Gestion des groupes", "/cartoun/templates/ficheProfil", map, map);
                } else if ((disciplinePageUrl == null) && (principal.getName().endsWith(ENSPUBLIC) || principal.getName().endsWith(ENSPRIVE))) {
                    disciplinePageUrl = urlFactory.getStartPageUrl(portalControllerContext, "Mes Disciplines", "/cartoun/templates/disciplines", map, map);
                }
                if ((ficheProfilPageUrl != null) && (disciplinePageUrl != null)) {
                    break;
                }
            }
        } catch (final PortalException e) {
            throw new ControllerException(e);
        }
        attributes.put(DISCIPLINES_PAGE_URL, disciplinePageUrl);
        attributes.put(FICHE_PROFIL_PAGE_URL, ficheProfilPageUrl);
        attributes.put(FICHE_PERSONNE_PAGE_URL, fichePersonnePageUrl);
    }

    @Override
    public Set<String> getAttributeNames() {
        return names;
    }

}
