/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.plugin.util;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class BapeListCommand
implements INuxeoCommand {
    private static final String SCHEMAS = "dublincore, toutatice";
    private final String domainPath;

    public BapeListCommand(String domainPath) {
        this.domainPath = domainPath;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest operationRequest;
        StringBuilder request = new StringBuilder();
        request.append("ecm:primaryType = 'ENTbape' ");
        request.append("AND ecm:path STARTSWITH '").append(this.domainPath).append("' ");
        request.append("ORDER BY dc:title ASC");
        String query = "SELECT * FROM Document WHERE " + NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE, (String)request.toString());
        if (NuxeoCompatibility.canUseES()) {
            operationRequest = nuxeoSession.newRequest("Document.QueryES");
            operationRequest.set("X-NXDocumentProperties", (Object)SCHEMAS);
            operationRequest.set("pageSize", (Object)-1);
            operationRequest.set("currentPageIndex", (Object)0);
        } else {
            operationRequest = nuxeoSession.newRequest("Document.Query");
            operationRequest.setHeader("X-NXDocumentProperties", SCHEMAS);
        }
        operationRequest.set("query", (Object)query.toString());
        return operationRequest.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getCanonicalName());
        builder.append("/");
        builder.append(this.domainPath);
        return builder.toString();
    }
}

