package fr.toutatice.cartoun.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

import javax.portlet.PortletException;

import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.theming.TabGroup;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSExtendedDocumentInfos;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.DomainContextualization;

import fr.toutatice.cartoun.plugin.cms.CartounDomainContextualization;
import fr.toutatice.cartoun.plugin.fragment.BapeSelectorFragmentModule;
import fr.toutatice.cartoun.plugin.fragment.CleanSelectorsFragmentModule;
import fr.toutatice.cartoun.plugin.theming.CartographyTabGroup;
import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.IMenubarModule;

/**
 * Cartoun plugin.
 *
 * @author Cédric Krommenhoek
 * @see AbstractPluginPortlet
 */
public class CartounPlugin extends AbstractPluginPortlet implements IMenubarModule {

	/** Plugin name. */
	private static final String PLUGIN_NAME = "cartoun.plugin";

	/** Internationalization bundle factory. */
	private IBundleFactory bundleFactory;

    /** menubarItems to remove */
    private static final Set<String> itemsToRemove = new HashSet<String>(Arrays.asList("LOCK_URL", "SHARE_BY_EMAIL"));

	/**
	 * Constructor.
	 */
	public CartounPlugin() {
		super();
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public void init() throws PortletException {
		super.init();

		// Internationalization bundle factory
		final IInternationalizationService internationalizationService = Locator.findMBean(IInternationalizationService.class,
				IInternationalizationService.MBEAN_NAME);
		this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getPluginName() {
		return PLUGIN_NAME;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void customizeCMSProperties(String customizationID, CustomizationContext context) {
		// Document types
		this.customizeDocumentTypes(context);
		// Fragment types
		this.customizeFragmentTypes(context);
		// Tab groups
        this.customizeTabGroups(context);
        // Domain Contextualization
        this.customizeDomainContextualization(context);
        // update menuBar
        final List<IMenubarModule> menubars = getMenubars(context);
        menubars.add(this);
	}


    private void customizeDomainContextualization(CustomizationContext context) {
        final List<DomainContextualization> domainContextualizations = this.getDomainContextualizations(context);
        domainContextualizations.add(new CartounDomainContextualization());
    }


    /**
     * Customize document types.
     *
     * @param context customization context
     */
	private void customizeDocumentTypes(CustomizationContext context) {
		final Map<String, DocumentType> types = this.getDocTypes(context);

		// SAP
		final DocumentType sap = new DocumentType("UsageNumServiceMetier", true, true, true, false, true, false, new ArrayList<String>(0), "/default/templates/sap",
				"glyphicons glyphicons-tree-deciduous");
		types.put(sap.getName(), sap);

		// DAP
		final DocumentType dap = new DocumentType("UsageNumDossier", true, false, false, false, false, false, new ArrayList<String>(0), null,
				"glyphicons glyphicons-folder-closed");
		types.put(dap.getName(), dap);

		// Activity
        final DocumentType activity = new DocumentType("UsageNum", false, false, false, false, false, true, new ArrayList<String>(0), null,
                "glyphicons glyphicons-activity", false, false);
		types.put(activity.getName(), activity);
	}


	/**
	 * Customize fragment types.
	 *
	 * @param context customization context
	 */
	private void customizeFragmentTypes(CustomizationContext context) {
		// Internationalization bundle
		final Bundle bundle = this.bundleFactory.getBundle(context.getLocale());

		// Fragment types
		final List<FragmentType> types = this.getFragmentTypes(context);

		// BAPE selector
		final FragmentType bapeSelector = new FragmentType("bape-selector", bundle.getString("FRAGMENT_TYPE_BAPE_SELECTOR"), new BapeSelectorFragmentModule(
				this.getPortletContext()));
		types.add(bapeSelector);

        // clean selector
        final FragmentType cleanSelectors = new FragmentType("clean-selectors", bundle.getString("FRAGMENT_TYPE_CLEAN_SELECTORS"),
                new CleanSelectorsFragmentModule(this.getPortletContext()));
        types.add(cleanSelectors);
	}


    /**
     * Customize tab groups.
     *
     * @param context customization context
     */
    private void customizeTabGroups(CustomizationContext context) {
        // Tab groups
        final Map<String, TabGroup> tabGroups = this.getTabGroups(context);

        // Cartography
        final TabGroup cartography = new CartographyTabGroup(getDirectoryService());
        tabGroups.put(cartography.getName(), cartography);
    }


    @Override
    public void adaptContentMenuBar(CMSServiceCtx ctx, List<MenubarItem> menuBar, CMSPublicationInfos publicationInfos,
            CMSExtendedDocumentInfos extendedDocumentInfos) throws CMSException {

        final ListIterator<MenubarItem> menuBarIterator = menuBar.listIterator();

        while (menuBarIterator.hasNext()) {
            final MenubarItem menubarItem = menuBarIterator.next();
            if (itemsToRemove.contains(menubarItem.getId())) {
                menuBarIterator.remove();
            }
        }
    }

}
