package fr.toutatice.cartoun.plugin.fragment;

import java.io.IOException;

import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.Constants;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.sequencing.IPortletSequencingService;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;


public class WebIdACASelectorFragmentModule extends FragmentModule {

    private static final String JSP_NAME = "bape-selector";

    /** portletSequencingService */
    private IPortletSequencingService portletSequencingService;

    public WebIdACASelectorFragmentModule(PortletContext portletContext) {
        super(portletContext);
        portletSequencingService = Locator.findMBean(IPortletSequencingService.class, IPortletSequencingService.MBEAN_NAME);
    }

    @Override
    protected void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {

        final NuxeoController nuxeoController = new NuxeoController(request, response, this.getPortletContext());

        HttpServletRequest servletRequest = (HttpServletRequest) request.getAttribute(Constants.PORTLET_ATTR_HTTP_REQUEST);

        String webIdACA = (String) servletRequest.getSession().getAttribute("webIdACA");
        webIdACA = StringUtils.removeStart(webIdACA, "sun_");

        portletSequencingService.setAttribute(nuxeoController.getPortalCtx(), "codeAcademie", webIdACA);

        super.doView(request, response, portletContext);
    }

    @Override
    public boolean isDisplayedInAdmin() {
        return true;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public String getViewJSPName() {
        return JSP_NAME;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public String getAdminJSPName() {
        return JSP_NAME;
    }
}
