package fr.toutatice.cartoun.customizer.attributes;

import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;

import org.apache.commons.lang.StringUtils;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.theme.PageRendition;
import org.jboss.portal.security.impl.jacc.JACCPortalPrincipal;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.theming.IAttributesBundle;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.constants.InternalConstants;


public class CustomToolbarAttributesBundle implements IAttributesBundle {

    private static final  String FICHE_PERSONNE_PAGE_URL = "acrennes.sites.cartoun.fichePersonnePage.url";

    private static final String CREATIONCOMPTE_TITLE = System.getProperty("toutatice.cartoun.creationcompte.title", "Mon Profil");

    private static final String CREATIONCOMPTE_PORTLET = "toutatice-cartoun-creationcompte-portailPortletInstance";

    private static final Pattern DISCIPLINE_REGEXP = Pattern.compile(System.getProperty("toutatice.cartoun.toolbar.rule.discipline",
            "^.+_IPR$|^.+_.+_EnsPublic$|^.+_.+_EnsPrive$"));

    private static final String DISCIPLINE_PAGE_NAME = "Mes Disciplines";

    private static final String DISCIPLINE_TEMPLATE = "/cartoun/templates/disciplines";

    private static final String DISCIPLINES_PAGE_URL = "acrennes.sites.cartoun.disciplinesPage.url";

    private static final Pattern GROUPES_REGEXP = Pattern.compile(System.getProperty("toutatice.cartoun.toolbar.rule.groupes",
            "^.+_.+_IPR$|^.+_Administrateur$|^Administrators$|^0\\d{2}_(\\d{3}|02A|02B)_Responsable$"));

    private static final String GROUPES_PAGE_NAME = "Gestion des groupes";

    private static final String GROUPES_TEMPLATE = "/cartoun/templates/ficheProfil";

    private static final String FICHE_PROFIL_PAGE_URL = "acrennes.sites.cartoun.ficheProfilPage.url";

    private static final Pattern STATISTIQUE_REGEXP = Pattern.compile(System.getProperty("toutatice.cartoun.toolbar.rule.statistiques", "^.+_Statistiques$"));

    private static final String STATISTIQUE_PAGE_NAME = "Statistiques";

    private static final String STATISTIQUE_TEMPLATE = "/cartoun/templates/Statistiques";

    private static final String STATISTIQUE_PAGE_URL = "acrennes.sites.cartoun.statistiquesPage.url";

    private static final String ACCOMPAGNEMENT_PAGE_URL = "acrennes.sites.cartoun.accompagnementPage.url";

    private static final String ACCOMPAGNEMENT_PATH = "/default-domain/accompagnement";

    private static final String LOGIN_URL = "acrennes.sites.cartoun.login.url";

    private static final String LOGIN_PATH = "/portail/auth";


    /** Portal URL factory. */
    private final IPortalUrlFactory urlFactory;
    /** Toolbar attributes names. */
    private final Set<String> names;

    /**
     * Singleton Holder
     */
    private static class CustomToolbarAttributesBundleHolder {

        private static final CustomToolbarAttributesBundle INSTANCE = new CustomToolbarAttributesBundle();
    }

    /**
     * Singleton instance access.
     *
     * @return singleton instance
     */
    public static CustomToolbarAttributesBundle getInstance() {
        return CustomToolbarAttributesBundleHolder.INSTANCE;
    }

    /**
     * Constructor
     */
    private CustomToolbarAttributesBundle() {
        // URL factory
        urlFactory = Locator.findMBean(IPortalUrlFactory.class, IPortalUrlFactory.MBEAN_NAME);
        names = new TreeSet<String>();
        names.add(DISCIPLINES_PAGE_URL);
        names.add(FICHE_PROFIL_PAGE_URL);
        names.add(FICHE_PERSONNE_PAGE_URL);
        names.add(STATISTIQUE_PAGE_URL);
        names.add(LOGIN_URL);
        names.add(ACCOMPAGNEMENT_PAGE_URL);
    }

    @Override
    public void fill(RenderPageCommand renderPageCommand, PageRendition pageRendition, Map<String, Object> attributes) throws ControllerException {
        final ControllerContext controllerContext = renderPageCommand.getControllerContext();
        final PortalControllerContext portalControllerContext = new PortalControllerContext(controllerContext);

        // Get the current authenticated subject through the JACC
        // contract
        Subject subject;
        try {
            subject = (Subject) PolicyContext.getContext("javax.security.auth.Subject.container");
        } catch (PolicyContextException e) {
            throw new ControllerException(e);
        }

        // utilisation mapping standard du portail
        String disciplinePageUrl = null;
        String ficheProfilPageUrl = null;
        String fichePersonnePageUrl = null;
        String statistiquePageUrl = null;
        String loginUrl = null;
        String accompagnementUrl = null;
        try {
            final Map<String, String> map = new HashMap<String, String>();

            final Map<String, String> ccWindowProp = new HashMap<String, String>();
            ccWindowProp.put("osivia.hideTitle", "1");
            ccWindowProp.put(InternalConstants.PROP_WINDOW_TITLE, CREATIONCOMPTE_TITLE);


            final Map<String, String> renderParamMap = new HashMap<String, String>();
            renderParamMap.put("action", "monCompte");

            fichePersonnePageUrl = urlFactory.getStartPortletInNewPage(portalControllerContext, CREATIONCOMPTE_TITLE, CREATIONCOMPTE_TITLE,
                    CREATIONCOMPTE_PORTLET, ccWindowProp, renderParamMap);

            loginUrl = urlFactory.getBasePortalUrl(portalControllerContext).concat(LOGIN_PATH);

            accompagnementUrl = urlFactory.getCMSUrl(portalControllerContext, null, ACCOMPAGNEMENT_PATH, null, null, null, null, null, null, null);
            if (subject != null) {
                JACCPortalPrincipal pp = new JACCPortalPrincipal(subject);
                Iterator iter = pp.getRoles().iterator();
                while (iter.hasNext()) {
                    Principal principal = (Principal) iter.next();
                    String groupName = principal.getName();

                    if ((ficheProfilPageUrl == null) && StringUtils.isNotBlank(GROUPES_REGEXP.pattern()) && GROUPES_REGEXP.matcher(groupName).matches()) {
                        ficheProfilPageUrl = urlFactory.getStartPageUrl(portalControllerContext, GROUPES_PAGE_NAME, GROUPES_TEMPLATE, map, map);
                    }
                    if ((disciplinePageUrl == null) && StringUtils.isNotBlank(DISCIPLINE_REGEXP.pattern()) && DISCIPLINE_REGEXP.matcher(groupName).matches()) {
                        disciplinePageUrl = urlFactory.getStartPageUrl(portalControllerContext, DISCIPLINE_PAGE_NAME, DISCIPLINE_TEMPLATE, map, map);
                    }
                    if ((statistiquePageUrl == null) && StringUtils.isNotBlank(STATISTIQUE_REGEXP.pattern()) && STATISTIQUE_REGEXP.matcher(groupName).matches()) {
                        statistiquePageUrl = urlFactory.getStartPageUrl(portalControllerContext, STATISTIQUE_PAGE_NAME, STATISTIQUE_TEMPLATE, map, map);
                    }

                    if ((ficheProfilPageUrl != null) && (disciplinePageUrl != null) && (statistiquePageUrl != null)) {
                        // cela ne sert plus a rien de chercher
                        break;
                    }
                }
            }
        } catch (final PortalException e) {
            throw new ControllerException(e);
        }
        attributes.put(LOGIN_URL, loginUrl);
        attributes.put(ACCOMPAGNEMENT_PAGE_URL, accompagnementUrl);
        attributes.put(DISCIPLINES_PAGE_URL, disciplinePageUrl);
        attributes.put(FICHE_PROFIL_PAGE_URL, ficheProfilPageUrl);
        attributes.put(FICHE_PERSONNE_PAGE_URL, fichePersonnePageUrl);
        attributes.put(STATISTIQUE_PAGE_URL, statistiquePageUrl);
    }

    @Override
    public Set<String> getAttributeNames() {
        return names;
    }

}
