package fr.toutatice.cartoun.plugin.util;

import org.nuxeo.ecm.automation.client.Constants;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;

/**
 * DAP list command.
 *
 * @author Cédric Krommenhoek
 * @see INuxeoCommand
 */
public class CircoListCommand implements INuxeoCommand {

    /** Schemas. */
    private static final String SCHEMAS = "dublincore, toutatice";


    /** Domain path. */
    private final String domainPath;


    /**
     * Constructor.
     *
     * @param domainPath domain path
     */
    public CircoListCommand(String domainPath) {
        super();
        this.domainPath = domainPath;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public Object execute(Session nuxeoSession) throws Exception {
        // NXQL Query
        final StringBuilder request = new StringBuilder();
        request.append("ecm:primaryType = 'ENTCirco' ");
        request.append("AND ecm:path STARTSWITH '").append(this.domainPath).append("' ");
        request.append("ORDER BY dc:title ASC");
        final String query = "SELECT * FROM Document WHERE " + NuxeoQueryFilter.addPublicationFilter(NuxeoQueryFilterContext.CONTEXT_LIVE, request.toString());

        // Operation request
        OperationRequest operationRequest;
        if (NuxeoCompatibility.canUseES()) {
            operationRequest = nuxeoSession.newRequest("Document.QueryES");
            operationRequest.set(Constants.HEADER_NX_SCHEMAS, SCHEMAS);
            operationRequest.set("pageSize", -1);
            operationRequest.set("currentPageIndex", 0);
        } else {
            operationRequest = nuxeoSession.newRequest("Document.Query");
            operationRequest.setHeader(Constants.HEADER_NX_SCHEMAS, SCHEMAS);
        }
        operationRequest.set("query", query.toString());

        return operationRequest.execute();
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public String getId() {
        final StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getCanonicalName());
        builder.append("/");
        builder.append(this.domainPath);
        return builder.toString();
    }

}
