/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.plugin;

import fr.toutatice.cartoun.plugin.cms.CartounDomainContextualization;
import fr.toutatice.cartoun.plugin.fragment.BapeSelectorFragmentModule;
import fr.toutatice.cartoun.plugin.fragment.CleanSelectorsFragmentModule;
import fr.toutatice.cartoun.plugin.fragment.WebIdACASelectorFragmentModule;
import fr.toutatice.cartoun.plugin.theming.CartographyTabGroup;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.IMenubarModule;
import fr.toutatice.portail.cms.nuxeo.api.fragment.IFragmentModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSExtendedDocumentInfos;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class CartounPlugin
extends AbstractPluginPortlet
implements IMenubarModule {
    private static final String PLUGIN_NAME = "cartoun.plugin";
    private static final String FB_APP_ID = System.getProperty("acrennes.sites.cartoun.facebook.app.id");
    private IBundleFactory bundleFactory;
    private static final Set<String> itemsToRemove = new HashSet<String>(Arrays.asList("LOCK_URL", "SHARE_BY_EMAIL"));
    private IPortalUrlFactory urlFactory;

    public void init() throws PortletException {
        super.init();
        this.urlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    protected String getPluginName() {
        return PLUGIN_NAME;
    }

    protected void customizeCMSProperties(String customizationID, CustomizationContext context) {
        this.customizeDocumentTypes(context);
        this.customizeFragmentTypes(context);
        this.customizeTabGroups(context);
        this.customizeDomainContextualization(context);
        List menubars = this.getMenubars(context);
        menubars.add(this);
    }

    private void customizeDomainContextualization(CustomizationContext context) {
        List domainContextualizations = this.getDomainContextualizations(context);
        domainContextualizations.add(new CartounDomainContextualization());
    }

    private void customizeDocumentTypes(CustomizationContext context) {
        Map types = this.getDocTypes(context);
        DocumentType sap = new DocumentType("UsageNumServiceMetier", true, true, true, false, true, false, new ArrayList(0), "/default/templates/sap", "glyphicons glyphicons-tree-deciduous");
        types.put(sap.getName(), sap);
        DocumentType dap = new DocumentType("UsageNumDossier", true, false, false, false, false, false, new ArrayList(0), null, "glyphicons glyphicons-folder-closed");
        types.put(dap.getName(), dap);
        DocumentType activity = new DocumentType("UsageNum", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-activity", false, false);
        types.put(activity.getName(), activity);
    }

    private void customizeFragmentTypes(CustomizationContext context) {
        Bundle bundle = this.bundleFactory.getBundle(context.getLocale());
        List types = this.getFragmentTypes(context);
        FragmentType bapeSelector = new FragmentType("bape-selector", bundle.getString("FRAGMENT_TYPE_BAPE_SELECTOR"), (IFragmentModule)new BapeSelectorFragmentModule(this.getPortletContext()));
        types.add(bapeSelector);
        FragmentType cleanSelectors = new FragmentType("clean-selectors", bundle.getString("FRAGMENT_TYPE_CLEAN_SELECTORS"), (IFragmentModule)new CleanSelectorsFragmentModule(this.getPortletContext()));
        types.add(cleanSelectors);
        FragmentType webIdACASelector = new FragmentType("webIdACASelector", bundle.getString("FRAGMENT_TYPE_WEBID_SELECTORS"), (IFragmentModule)new WebIdACASelectorFragmentModule(this.getPortletContext()));
        types.add(webIdACASelector);
    }

    private void customizeTabGroups(CustomizationContext context) {
        Map tabGroups = this.getTabGroups(context);
        CartographyTabGroup cartography = new CartographyTabGroup(this.getDirectoryService());
        tabGroups.put(cartography.getName(), cartography);
    }

    public void adaptContentMenuBar(CMSServiceCtx ctx, List<MenubarItem> menuBar, CMSPublicationInfos publicationInfos, CMSExtendedDocumentInfos extendedDocumentInfos) throws CMSException {
        ListIterator<MenubarItem> menuBarIterator = menuBar.listIterator();
        while (menuBarIterator.hasNext()) {
            MenubarItem menubarItem = menuBarIterator.next();
            if (!itemsToRemove.contains(menubarItem.getId())) continue;
            menuBarIterator.remove();
        }
        Document doc = (Document)ctx.getDoc();
        if (doc != null && StringUtils.equals((String)doc.getType(), (String)"UsageNum")) {
            PortletRequest request = ctx.getRequest();
            MimeResponse response = ctx.getResponse();
            PortalControllerContext pcc = new PortalControllerContext(this.getPortletContext(), request, (PortletResponse)response);
            String canonicalURL = null;
            try {
                String webPath = NuxeoController.webIdToCmsPath((String)doc.getProperties().getString("ttc:webid"));
                canonicalURL = this.urlFactory.getPermaLink(pcc, null, null, webPath, "share");
            }
            catch (PortalException e) {
                throw new CMSException((Throwable)e);
            }
            String title = doc.getTitle();
            String target = "_blank";
            boolean shareable = BooleanUtils.isTrue((Boolean)doc.getProperties().getBoolean("unum:shareable"));
            MenubarDropdown dropdown = this.getMenubarService().getDropdown(pcc, "SHARE");
            if (dropdown != null && shareable) {
                MenubarItem item = new MenubarItem("SHARE_TWITTER", "Partager avec Twitter", "social social-twitter", (MenubarContainer)dropdown, 2, this.buildTwitterShareLink(canonicalURL, title), target, null, null);
                item.setAjaxDisabled(true);
                menuBar.add(item);
                if (StringUtils.isNotBlank((String)FB_APP_ID)) {
                    item = new MenubarItem("SHARE_FB", "Partager avec Facebook", "social social-facebook", (MenubarContainer)dropdown, 3, this.buildFacebookShareLink(canonicalURL), target, null, null);
                    item.setAjaxDisabled(true);
                    menuBar.add(item);
                }
                item = new MenubarItem("SHARE_LINKEDIN", "Partager avec LinkedIn", "social social-linked-in", (MenubarContainer)dropdown, 4, this.buildLinkedInShareLink(canonicalURL), target, null, null);
                item.setAjaxDisabled(true);
                menuBar.add(item);
                item = new MenubarItem("SHARE_VIADEO", "Partager avec Viadeo", "viadeo-glyph", (MenubarContainer)dropdown, 5, this.buildViadeoShareLink(canonicalURL), target, null, null);
                item.setAjaxDisabled(true);
                menuBar.add(item);
            }
        }
    }

    private String buildViadeoShareLink(String canonicalURL) {
        StringBuilder linksb = new StringBuilder("https://partners.viadeo.com/share");
        linksb.append("?url=");
        linksb.append(canonicalURL);
        return linksb.toString();
    }

    private String buildLinkedInShareLink(String canonicalURL) {
        StringBuilder linksb = new StringBuilder("https://www.linkedin.com/shareArticle?mini=true");
        linksb.append("&url=");
        linksb.append(canonicalURL);
        return linksb.toString();
    }

    private String buildTwitterShareLink(String permaLinkUrl, String title) {
        StringBuilder linksb = new StringBuilder("https://twitter.com/intent/tweet?");
        linksb.append("text=");
        linksb.append(StringUtils.replace((String)title, (String)" ", (String)"+"));
        linksb.append("+");
        linksb.append("%23cartoun");
        linksb.append("&url=");
        linksb.append(permaLinkUrl);
        return linksb.toString();
    }

    private String buildFacebookShareLink(String permaLinkUrl) {
        StringBuilder linksb = new StringBuilder("https://www.facebook.com/dialog/share?");
        linksb.append("app_id=");
        linksb.append(FB_APP_ID);
        linksb.append("&display=page");
        linksb.append("&href=");
        linksb.append(permaLinkUrl);
        linksb.append("&redirect_uri=");
        linksb.append(permaLinkUrl);
        return linksb.toString();
    }
}

