/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.plugin.fragment;

import fr.toutatice.cartoun.plugin.util.BapeListCommand;
import fr.toutatice.cartoun.plugin.util.CircoListCommand;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class BapeSelectorFragmentModule
extends FragmentModule {
    private static final String LABEL_WINDOW_PROPERTY = "bape.selector.label";
    private static final String TOOLTIP_LABEL_WINDOW_PROPERTY = "bape.selector.tooltip.label";
    private static final String BAPE_SELECTOR_ID_WINDOW_PROPERTY = "bape.selector.id";
    private static final String CIRCO_SELECTOR_ID_WINDOW_PROPERTY = "circo.selector.id";
    private static final String WEBID_PREFIX_BAPE = "bape_";
    private static final String WEBID_PREFIX_CIRCO = "circo_";
    private static final String JSP_NAME = "bape-selector";
    private IBundleFactory bundleFactory;

    public BapeSelectorFragmentModule(PortletContext portletContext) {
        super(portletContext);
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    protected void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        String domainPath = nuxeoController.getDomainPath();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        request.setAttribute("label", (Object)window.getProperty(LABEL_WINDOW_PROPERTY));
        request.setAttribute("tooltipLabel", (Object)window.getProperty(TOOLTIP_LABEL_WINDOW_PROPERTY));
        if (StringUtils.isNotEmpty((String)domainPath)) {
            JSONObject selectEntry;
            List values;
            BapeListCommand command = new BapeListCommand(domainPath);
            Documents bapes = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            command = new CircoListCommand(domainPath);
            Documents circos = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            if (bapes.isEmpty() && circos.isEmpty()) {
                request.setAttribute("osivia.emptyResponse", (Object)"1");
            }
            JSONArray data = new JSONArray();
            String bapeSelectorId = window.getProperty(BAPE_SELECTOR_ID_WINDOW_PROPERTY);
            String circoSelectorId = window.getProperty(CIRCO_SELECTOR_ID_WINDOW_PROPERTY);
            Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
            String selectedId = null;
            if (bapeSelectorId != null && CollectionUtils.isNotEmpty((Collection)(values = (List)selectors.get(bapeSelectorId)))) {
                selectedId = (String)values.get(0);
            }
            if (circoSelectorId != null && CollectionUtils.isNotEmpty((Collection)(values = (List)selectors.get(circoSelectorId)))) {
                selectedId = (String)values.get(0);
            }
            if (!bapes.isEmpty()) {
                JSONObject bapeGroup = new JSONObject();
                bapeGroup.put((Object)"id", (Object)"0");
                bapeGroup.put((Object)"text", (Object)bundle.getString("LABEL_BAPES"));
                JSONArray bapeChildren = new JSONArray();
                for (Document bape : bapes) {
                    if (StringUtils.equals((String)selectedId, (String)bape.getProperties().getString("ttc:webid"))) {
                        LinkedHashMap<String, String> bapeItem = new LinkedHashMap<String, String>();
                        bapeItem.put("id", bape.getProperties().getString("ttc:webid"));
                        bapeItem.put("text", bape.getTitle());
                        request.setAttribute("bapeItem", bapeItem);
                        continue;
                    }
                    selectEntry = new JSONObject();
                    selectEntry.put((Object)"id", (Object)bape.getProperties().getString("ttc:webid"));
                    selectEntry.put((Object)"text", (Object)bape.getTitle());
                    bapeChildren.add((Object)selectEntry);
                }
                bapeGroup.put((Object)"children", (Object)bapeChildren);
                data.add((Object)bapeGroup);
            }
            if (!circos.isEmpty()) {
                JSONObject circoGroup = new JSONObject();
                circoGroup.put((Object)"id", (Object)"1");
                circoGroup.put((Object)"text", (Object)bundle.getString("LABEL_CIRCO"));
                JSONArray circoChildren = new JSONArray();
                for (Document circo : circos) {
                    if (StringUtils.equals((String)selectedId, (String)circo.getProperties().getString("ttc:webid"))) {
                        LinkedHashMap<String, String> circoItem = new LinkedHashMap<String, String>();
                        circoItem.put("id", circo.getProperties().getString("ttc:webid"));
                        circoItem.put("text", circo.getTitle());
                        request.setAttribute("circoItem", circoItem);
                        continue;
                    }
                    selectEntry = new JSONObject();
                    selectEntry.put((Object)"id", (Object)circo.getProperties().getString("ttc:webid"));
                    selectEntry.put((Object)"text", (Object)circo.getTitle());
                    circoChildren.add((Object)selectEntry);
                }
                circoGroup.put((Object)"children", (Object)circoChildren);
                data.add((Object)circoGroup);
            }
            request.setAttribute("data", (Object)data.toString());
        }
    }

    protected void doAdmin(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        new NuxeoController((PortletRequest)request, (PortletResponse)response, portletContext);
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        request.setAttribute("label", (Object)window.getProperty(LABEL_WINDOW_PROPERTY));
        request.setAttribute("tooltipLabel", (Object)window.getProperty(TOOLTIP_LABEL_WINDOW_PROPERTY));
        request.setAttribute("selectorId", (Object)window.getProperty(BAPE_SELECTOR_ID_WINDOW_PROPERTY));
        request.setAttribute("circoSelectorId", (Object)window.getProperty(CIRCO_SELECTOR_ID_WINDOW_PROPERTY));
    }

    protected void processAction(ActionRequest request, ActionResponse response, PortletContext portletContext) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if (PortletMode.VIEW.equals((Object)request.getPortletMode()) && "filter".equals(request.getParameter("javax.portlet.action"))) {
            String bapeSelectorId = window.getProperty(BAPE_SELECTOR_ID_WINDOW_PROPERTY);
            String circoSelectorId = window.getProperty(CIRCO_SELECTOR_ID_WINDOW_PROPERTY);
            if (bapeSelectorId != null || circoSelectorId != null) {
                String selectedId = request.getParameter("selectedId");
                Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                if (request.getParameter("selectors") != null) {
                    response.setRenderParameter("lastSelectors", request.getParameter("selectors"));
                }
                selectors.remove(bapeSelectorId);
                selectors.remove(circoSelectorId);
                if (request.getParameter("clear") == null) {
                    if (StringUtils.startsWith((String)selectedId, (String)WEBID_PREFIX_BAPE)) {
                        ArrayList<String> values = new ArrayList<String>(1);
                        values.add(selectedId);
                        selectors.put(bapeSelectorId, values);
                    } else if (StringUtils.startsWith((String)selectedId, (String)WEBID_PREFIX_CIRCO)) {
                        ArrayList<String> values = new ArrayList<String>(1);
                        values.add(selectedId);
                        selectors.put(circoSelectorId, values);
                    }
                }
                response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
            }
        } else if ("admin".equals(request.getPortletMode().toString()) && "save".equals(request.getParameter("javax.portlet.action"))) {
            window.setProperty(LABEL_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("label")));
            window.setProperty(TOOLTIP_LABEL_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("tooltipLabel")));
            window.setProperty(BAPE_SELECTOR_ID_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("bapeSelectorId")));
            window.setProperty(CIRCO_SELECTOR_ID_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("circoSelectorId")));
        }
    }

    public boolean isDisplayedInAdmin() {
        return true;
    }

    public String getViewJSPName() {
        return JSP_NAME;
    }

    public String getAdminJSPName() {
        return JSP_NAME;
    }
}

