/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.plugin.theming;

import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.IDirectoryService;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.theming.TabGroup;

public class CartographyTabGroup
implements TabGroup {
    private static final String NAME = "cartography";
    private static final String ICON = "halflings halflings-map-marker";
    private static final String LABEL_KEY = "CARTOGRAPHY";
    private final IDirectoryService directoryService;

    public CartographyTabGroup(IDirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    public String getName() {
        return NAME;
    }

    public String getIcon() {
        return ICON;
    }

    public String getLabelKey() {
        return LABEL_KEY;
    }

    public boolean contains(PortalControllerContext portalControllerContext, EcmDocument document, String type, Map<String, String> pageProperties) {
        return document != null && !StringUtils.startsWith((String)((Document)document).getPath(), (String)"/default-domain/");
    }

    public boolean maintains(PortalControllerContext portalControllerContext, EcmDocument document, String type, Map<String, String> pageProperties) {
        boolean maintains;
        HttpServletRequest httpServletRequest = portalControllerContext.getHttpServletRequest();
        Principal userPrincipal = httpServletRequest.getUserPrincipal();
        if (userPrincipal != null && document instanceof Document) {
            String webIdACA = (String)httpServletRequest.getSession().getAttribute("webIdACA");
            if (webIdACA == null) {
                String uid = userPrincipal.getName();
                DirectoryPerson person = this.directoryService.getPerson(uid);
                String academy = (String)person.getExtraProperties().get("codeAcademie");
                webIdACA = "sun_" + academy;
                httpServletRequest.getSession().setAttribute("webIdACA", (Object)webIdACA);
            }
            Document nuxeoDocument = (Document)document;
            maintains = StringUtils.equals((String)webIdACA, (String)nuxeoDocument.getString("ttc:webid"));
        } else {
            maintains = false;
        }
        return maintains;
    }
}

