/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.portlet.detailactivite.controller;

import com.sun.mail.smtp.SMTPTransport;
import fr.toutatice.cartoun.portlet.detailactivite.bean.ActiviteBean;
import fr.toutatice.cartoun.portlet.detailactivite.bean.LinkBean;
import fr.toutatice.cartoun.portlet.detailactivite.bean.ReferentBean;
import fr.toutatice.cartoun.portlet.detailactivite.command.BecomeReferentCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.CtrlPermissionCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.DeleteReferentCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.PermalinkCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.RetrieveActiviteByIdCommand;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.ICMSService;
import org.springframework.expression.ParseException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class DetailActiviteController
extends CMSPortlet
implements PortletContextAware,
PortletConfigAware {
    protected static final Log logger = LogFactory.getLog(DetailActiviteController.class);
    private static final String VIGNETTE_DEFAUT_WEBID = "vignette-par-defaut";
    private static final String PIA_CMS_URI = "osivia.cms.uri";
    private static final String ERROR_PAGE = "error";
    private static final String ACTIVITE_PAGE = "detailActivite";
    private PortletContext portletContext;
    private PortletConfig portletConfig;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
    }

    public void destroy() {
        super.destroy();
    }

    @PostConstruct
    public void initNuxeoService() throws Exception {
        super.init();
        if (this.portletContext != null && this.portletContext.getAttribute("nuxeoService") == null) {
            logger.info((Object)" Start  nuxeo service ...");
            this.init(this.portletConfig);
            logger.info((Object)"Nuxeo service  started! ");
        }
    }

    @PreDestroy
    public void cleanUpNuxeoService() throws Exception {
        if (this.portletContext != null && this.portletContext.getAttribute("nuxeoService") == null) {
            logger.info((Object)" Stop  nuxeo service ...");
            this.destroy();
            logger.info((Object)"Nuxeo service  stopped! ");
        }
    }

    @RequestMapping
    public String showActivite(RenderRequest request, RenderResponse response, PortletSession session) throws Exception {
        String returnPage = ERROR_PAGE;
        ActiviteBean act = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String pathAct = window.getProperty(PIA_CMS_URI);
        window.setProperty("osivia.permalinkportlet", "1");
        if (pathAct != null && !"".equals(pathAct)) {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
            CMSPublicationInfos publicationInfos = NuxeoController.getCMSService().getPublicationInfos(nuxeoController.getCMSCtx(), pathAct);
            boolean beingModified = publicationInfos.isBeingModified();
            request.setAttribute("beingModified", (Object)beingModified);
            String level = request.getParameter("levelSelected");
            Document doc = null;
            if (StringUtils.isBlank((String)level)) {
                NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)pathAct);
                Document liveDoc = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new CtrlPermissionCommand("aspire", documentContext.getDoc(), null));
                Boolean canBecomeReferent = liveDoc != null;
                request.setAttribute("canBecomeReferent", (Object)canBecomeReferent);
                doc = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
            } else {
                DirectoryPerson person = (DirectoryPerson)request.getAttribute("osivia.loggedPerson");
                nuxeoController.setDisplayLiveVersion("1");
                NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)pathAct);
                doc = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
                nuxeoController.executeNuxeoCommand((INuxeoCommand)new BecomeReferentCommand(person.getUid(), level, doc));
                documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)pathAct);
                doc = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
            }
            act = this.commonInitialization(request, response, doc, nuxeoController);
        }
        if (act != null) {
            returnPage = ACTIVITE_PAGE;
        }
        return returnPage;
    }

    @RequestMapping(params={"action=refreshAfterDelete"})
    public String refreshAfterDeleteReferents(RenderRequest request, RenderResponse response, PortletSession session) throws Exception {
        String returnPage = ERROR_PAGE;
        ActiviteBean act = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String pathAct = window.getProperty(PIA_CMS_URI);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        nuxeoController.setDisplayLiveVersion("1");
        NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)pathAct);
        Document doc = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
        doc = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new DeleteReferentCommand(request.getParameter("selectedUid"), doc));
        Document liveDoc = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new CtrlPermissionCommand("aspire", doc, null));
        Boolean canBecomeReferent = liveDoc != null;
        request.setAttribute("canBecomeReferent", (Object)canBecomeReferent);
        documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)pathAct);
        doc = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
        act = this.commonInitialization(request, response, doc, nuxeoController);
        if (act != null) {
            returnPage = ACTIVITE_PAGE;
        }
        return returnPage;
    }

    @ActionMapping(params={"action=becomeReferent"})
    public void levelSelected(@ModelAttribute ReferentBean refForm, BindingResult result, ActionResponse response, ActionRequest request, PortletSession session) throws ParseException {
        String level = refForm.getLevelSelected();
        response.setRenderParameter("levelSelected", level);
        response.setRenderParameter("action", "default");
    }

    @ActionMapping(params={"action=deleteReferent"})
    public void deleteReferent(@RequestParam String uid, ActionResponse response, ActionRequest request, PortletSession session) throws ParseException {
        response.setRenderParameter("selectedUid", uid);
        response.setRenderParameter("action", "refreshAfterDelete");
    }

    @ResourceMapping
    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse, PortletSession session) throws PortletException, IOException {
        super.serveResource(resourceRequest, resourceResponse);
    }

    @ActionMapping(params={"action=toContact"})
    public void sendMail(@ModelAttribute ReferentBean refForm, BindingResult result, ActionResponse response, ActionRequest request, PortletSession session) {
        DirectoryPerson person = (DirectoryPerson)request.getAttribute("osivia.loggedPerson");
        Properties props = System.getProperties();
        Session mailSession = Session.getInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(mailSession);
        try {
            msg.setFrom((Address)new InternetAddress(person.getEmail()));
            msg.setSubject(refForm.getSubject(), "UTF-8");
            String mailDestinataire = refForm.getEmail();
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mailDestinataire, (boolean)false));
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart txtPart = new MimeBodyPart();
            txtPart.setText(refForm.getBodyMail(), "UTF-8");
            mp.addBodyPart((BodyPart)txtPart);
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            SMTPTransport t = (SMTPTransport)mailSession.getTransport();
            t.connect();
            t.sendMessage((Message)msg, msg.getAllRecipients());
            t.close();
        }
        catch (AddressException e) {
            logger.error((Object)"erreur envoi mail", (Throwable)e);
        }
        catch (MessagingException e) {
            logger.error((Object)"erreur envoi mail", (Throwable)e);
        }
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    private ActiviteBean commonInitialization(RenderRequest request, RenderResponse response, Document doc, NuxeoController nuxeoCtl) throws Exception, CMSException, UnsupportedEncodingException {
        String stats;
        Principal principal = request.getUserPrincipal();
        ActiviteBean act = this.convertNuxeoDocToActiviteBean(doc, nuxeoCtl, principal.getName());
        if (StringUtils.isNotBlank((String)doc.getString("unum:groupeViaeduc"))) {
            String link = (String)nuxeoCtl.executeNuxeoCommand((INuxeoCommand)new PermalinkCommand("viaeduclink", doc));
            act.setViaeduc(link);
        }
        if (StringUtils.equalsIgnoreCase((String)(stats = System.getProperty("stats.enable")), (String)"true")) {
            String idDun = doc.getPath().substring(0, doc.getPath().lastIndexOf(47));
            NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)idDun);
            Document dun = documentContext.getDoc();
            String dunName = dun.getString("dun:subtitle");
            if (dunName == null) {
                dunName = dun.getTitle();
            }
            dunName = dunName.trim();
            act.setDun(dunName);
        }
        request.setAttribute("activity", (Object)act);
        VocabularyEntry vocNivRef = VocabularyHelper.getVocabularyEntry((NuxeoController)nuxeoCtl, (String)"unu_niveauReferent");
        Collection childrenValue = vocNivRef.getChildren().values();
        request.setAttribute("voc", childrenValue);
        request.setAttribute("refForm", (Object)new ReferentBean());
        nuxeoCtl.setCurrentDoc(doc);
        nuxeoCtl.insertContentMenuBarItems();
        return act;
    }

    private ActiviteBean convertNuxeoDocToActiviteBean(Document doc, NuxeoController nxController, String uidCurrent) throws Exception {
        String urlVignette;
        ActiviteBean res = new ActiviteBean();
        res.setId(doc.getId());
        String label = VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_niveau", (String)doc.getString("unum:niv"));
        res.setLevel(label);
        label = VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_duree", (String)doc.getString("unum:duree"));
        res.setDuration(label);
        label = VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_transferabilite", (String)doc.getString("acrp:transferabilite"));
        res.setTransferability(label);
        res.setSummary(doc.getProperties().getString("unum:resume"));
        res.setScenario(doc.getProperties().getString("unum:scenario"));
        res.setTrap(doc.getProperties().getString("unum:piege"));
        res.setAnalysis(doc.getProperties().getString("unum:analyse"));
        res.setTitle(doc.getTitle());
        res.setLastContributor(doc.getProperties().getString("dc:lastContributor"));
        String uidAuthor = doc.getProperties().getString("dc:creator");
        if (StringUtils.isNotBlank((String)uidAuthor)) {
            DirectoryPerson person = this.getDirectoryService().getPerson(uidAuthor);
            if (person != null) {
                res.setAuthor(StringUtils.defaultString((String)person.getDisplayName()));
            } else {
                res.setAuthor(uidAuthor);
            }
        }
        res.setExperitheque(doc.getProperties().getBoolean("unum:experitheque"));
        res.setUrlExpe(doc.getProperties().getString("unum:urlExpe"));
        PropertyList lst = doc.getProperties().getList("acrp:disciplines");
        res.setLstDisciplines(this.protertyStringToListString(lst));
        lst = (PropertyList)doc.getProperties().get("acrp:niveauxEducatifs");
        res.setLstPublics(this.protertyStringToListString("carto_publicVise", lst, nxController));
        lst = (PropertyList)doc.getProperties().get("acrp:naturesPedagogiques");
        res.setLstPedagogicals(this.protertyStringToListString("unu_naturepeda", lst, nxController));
        lst = (PropertyList)doc.getProperties().get("unum:parcours");
        res.setLstParcours(this.protertyStringToListString(lst));
        lst = (PropertyList)doc.getProperties().get("unum:axe");
        res.setLstAxes(this.protertyStringToListString(lst));
        lst = (PropertyList)doc.getProperties().get("acrp:pratique");
        res.setLstPractices(this.protertyStringToListString("unu_pratiques", lst, nxController));
        lst = (PropertyList)doc.getProperties().get("acrp:cadresUtilisations");
        res.setLstCadres(this.protertyStringToListString("unu_modalite", lst, nxController));
        lst = (PropertyList)doc.getProperties().get("acrp:lieu");
        res.setLstPlaces(this.protertyStringToListString("unu_lieu", lst, nxController));
        lst = (PropertyList)doc.getProperties().get("acrp:outils");
        res.setLstTools(this.protertyStringToListString(lst));
        lst = (PropertyList)doc.getProperties().get("acrp:competences");
        res.setLstCompetence(this.protertyStringToListString(null, lst, nxController));
        lst = (PropertyList)doc.getProperties().get("unum:logicielLocal");
        res.setLstSoftware(this.protertyStringToListString(null, lst, nxController));
        lst = (PropertyList)doc.getProperties().get("unum:logicielInternet");
        ArrayList<LinkBean> lstESoftware = new ArrayList<LinkBean>();
        for (int i = 0; i < lst.size(); ++i) {
            lstESoftware.add(new LinkBean(lst.getMap(i).getString("name"), lst.getMap(i).getString("url")));
        }
        res.setLstESoftware(lstESoftware);
        lst = (PropertyList)doc.getProperties().get("unum:referents");
        ArrayList<ReferentBean> lstRefLevel1 = null;
        ArrayList<ReferentBean> lstRefLevel2 = null;
        for (Object referentsO : lst.list()) {
            PropertyMap referentMap = (PropertyMap)referentsO;
            if (referentMap.get("owner") != null && referentMap.getBoolean("owner").booleanValue()) {
                res.setOwner(referentMap.getString("uid"));
            }
            Integer iLevel = new Integer(referentMap.getString("niveau"));
            switch (iLevel) {
                case 1: {
                    if (lstRefLevel1 == null) {
                        lstRefLevel1 = new ArrayList<ReferentBean>();
                        res.setLabelReferent1(VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_niveauReferent", (String)"1"));
                    }
                    lstRefLevel1.add(new ReferentBean(referentMap, uidCurrent, uidAuthor));
                    break;
                }
                case 2: {
                    if (lstRefLevel2 == null) {
                        lstRefLevel2 = new ArrayList<ReferentBean>();
                        res.setLabelReferent2(VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_niveauReferent", (String)"2"));
                    }
                    lstRefLevel2.add(new ReferentBean(referentMap, uidCurrent, uidAuthor));
                    break;
                }
                case 3: {
                    if (lstRefLevel2 == null) {
                        lstRefLevel2 = new ArrayList();
                        res.setLabelReferent3(VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)"unu_niveauReferent", (String)"3"));
                    }
                    lstRefLevel2.add(new ReferentBean(referentMap, uidCurrent, uidAuthor));
                }
            }
        }
        res.setLstReferent1(lstRefLevel1);
        res.setLstReferent2(lstRefLevel2);
        PropertyMap map = doc.getProperties().getMap("ttc:vignette");
        if (map != null) {
            urlVignette = nxController.createFileLink(doc, "ttc:vignette");
            res.setUrlVignette("<img class=\"kartoun-titre-img-float\" src=\"" + urlVignette + "\" />");
        } else {
            urlVignette = this.getPictureLinkByWebId(nxController, VIGNETTE_DEFAUT_WEBID);
            res.setUrlVignette("<img class=\"kartoun-titre-img-float img-responsive\" src=\"" + urlVignette + "\" />");
        }
        if (doc.getDate("dc:issued") != null) {
            res.setDatePublication(doc.getDate("dc:issued"));
        } else {
            res.setDatePublication(doc.getDate("dc:modified"));
        }
        if (doc.getPath().endsWith(".proxy")) {
            res.setDraft(Boolean.valueOf(false));
        } else {
            res.setDraft(Boolean.valueOf(true));
        }
        PropertyList files = doc.getProperties().getList("files:files");
        if (null != files && !files.isEmpty()) {
            HashMap<String, String> mapPj = new HashMap<String, String>(files.size());
            for (int idx = 0; idx < files.size(); ++idx) {
                mapPj.put(files.getMap(idx).getString("filename"), nxController.createAttachedFileLink(doc.getPath(), String.valueOf(idx)));
            }
            res.setPj(mapPj);
        }
        return res;
    }

    private String getPictureLinkByWebId(NuxeoController nuxeoController, String webId) {
        String vignetteCmsPath;
        String vignetteGeneriquePath = NuxeoController.webIdToFetchPath((String)webId);
        ICMSService cmsService = NuxeoController.getCMSService();
        try {
            vignetteCmsPath = cmsService.adaptWebPathToCms(nuxeoController.getCMSCtx(), vignetteGeneriquePath);
        }
        catch (CMSException e) {
            return "";
        }
        return nuxeoController.createPictureLink(vignetteCmsPath, "Original");
    }

    private List<String> protertyStringToListString(String vocabularyName, PropertyList lst, NuxeoController nxController) throws Exception {
        ArrayList<String> lstString = new ArrayList<String>();
        if (lst != null) {
            for (Object propertyO : lst.list()) {
                String property = (String)propertyO;
                if (vocabularyName != null) {
                    String[] keys = StringUtils.split((String)property, (char)'/');
                    lstString.add(VocabularyHelper.getVocabularyLabel((NuxeoController)nxController, (String)vocabularyName, (String)keys[keys.length - 1]));
                    continue;
                }
                lstString.add(property);
            }
        }
        return lstString;
    }

    private List<String> protertyStringToListString(PropertyList lst) {
        ArrayList<String> lstString = new ArrayList<String>();
        if (lst != null) {
            for (Object propertyO : lst.list()) {
                String property = (String)propertyO;
                lstString.add(property);
            }
        }
        return lstString;
    }
}

