package fr.toutatice.cartoun.plugin.detailactivite;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceURL;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.player.IPlayerModule;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSExtendedDocumentInfos;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.portail.cms.nuxeo.api.domain.IMenubarModule;

public class DetailActivitePlugin extends AbstractPluginPortlet implements IMenubarModule {

    /** Plugin name. */
    private static final String PLUGIN_NAME = "detail.activite.plugin";

    /** Bundle factory. */
    protected IBundleFactory bundleFactory;

    @Override
    public void init() throws PortletException {
        super.init();

        // Bundle factory
        final IInternationalizationService internationalizationService = Locator.findMBean(IInternationalizationService.class,
                IInternationalizationService.MBEAN_NAME);
        bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    @Override
    protected String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    protected void customizeCMSProperties(String customizationID, CustomizationContext context) {
        final Map<String, DocumentType> docTypes = getDocTypes(context);

        final ArrayList<String> portalFormSubTypes = new ArrayList<String>(0);
        docTypes.put(DetailActivitePlayer.DOCTYPE_UsageNUm, new DocumentType(DetailActivitePlayer.DOCTYPE_UsageNUm, false, false, false, false, false, true,
                portalFormSubTypes, null, null, false, false, false));

        final List<IPlayerModule> modules = getPlayers(context);
        modules.add(0, new DetailActivitePlayer(getPortletContext()));

        List<IMenubarModule> menubars = getMenubars(context);
        menubars.add(this);
    }

    @Override
    public void adaptContentMenuBar(CMSServiceCtx C, List<MenubarItem> menuBar, CMSPublicationInfos publicationInfos,
            CMSExtendedDocumentInfos extendedDocumentInfos) throws CMSException {

        Document doc = (Document) C.getDoc();

        if ((doc != null) && StringUtils.equals(doc.getType(), "UsageNum")) {
            PortletRequest request = C.getRequest();
            final MimeResponse response = C.getResponse();
            // Export PDF
            MenubarItem item;
            // generate url to resource
            final ResourceURL resourceUrl = response.createResourceURL();
            resourceUrl.setResourceID("exportPDF");
            String exportPDFUrl = resourceUrl.toString();
            Bundle bundle = bundleFactory.getBundle(request.getLocale());
            item = new MenubarItem("EXPORT_PDF", bundle.getString("label.export.pdf"), "glyphicons glyphicons-print", MenubarGroup.SPECIFIC, 1, exportPDFUrl,
                    "_blank", null, null);
            item.setAjaxDisabled(true);
            menuBar.add(item);
        }
    }
}
