package fr.toutatice.cartoun.portlet.detailactivite.controller;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import javax.annotation.PostConstruct;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.Constants;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.ICMSService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.ParseException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

import com.sun.mail.smtp.SMTPTransport;

import fr.toutatice.cartoun.portlet.detailactivite.bean.ActiviteBean;
import fr.toutatice.cartoun.portlet.detailactivite.bean.LinkBean;
import fr.toutatice.cartoun.portlet.detailactivite.bean.ReferentBean;
import fr.toutatice.cartoun.portlet.detailactivite.command.BecomeReferentCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.CtrlPermissionCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.DeleteReferentCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.GetUserProfileCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.PermalinkCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.RetrieveActiviteByIdCommand;
import fr.toutatice.cartoun.portlet.detailactivite.service.IExportService;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;


@Controller
@RequestMapping("VIEW")
public class DetailActiviteController extends CMSPortlet implements PortletContextAware, PortletConfigAware {

    protected static final Log logger = LogFactory.getLog(DetailActiviteController.class);

    private static final String VIGNETTE_DEFAUT_WEBID = "vignette-par-defaut";

    private static final String PIA_CMS_URI = "osivia.cms.uri";
    private static final String ERROR_PAGE = "error";
    private static final String ACTIVITE_PAGE = "detailActivite";

    private PortletContext portletContext;
    private PortletConfig portletConfig;

    @Autowired
    private IExportService exportService;

    /**
     * Portlet initialization.
     *
     * @throws PortletException
     */
    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(portletConfig);
    }


    @RequestMapping
    public String showActivite(RenderRequest request, RenderResponse response, PortletSession session) throws Exception {
        String returnPage = ERROR_PAGE;


        ActiviteBean act = null;
        final PortalWindow window = WindowFactory.getWindow(request);
        final String pathAct = window.getProperty(PIA_CMS_URI);

        window.setProperty("osivia.permalinkportlet", "1");
        if ((pathAct != null) && !"".equals(pathAct)) {
            final NuxeoController nuxeoController = new NuxeoController(request, response, portletContext);
            final CMSPublicationInfos publicationInfos = NuxeoController.getCMSService().getPublicationInfos(nuxeoController.getCMSCtx(), pathAct);

            final boolean beingModified = publicationInfos.isBeingModified();
            request.setAttribute("beingModified", beingModified);

            final String level = request.getParameter("levelSelected");
            Document doc = null;
            if (StringUtils.isBlank(level)) {
                final NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext(request, response, getPortletContext(), pathAct);
                final Document liveDoc = (Document) nuxeoController.executeNuxeoCommand(new CtrlPermissionCommand("aspire", documentContext.getDoc(), null));
                final Boolean canBecomeReferent = (liveDoc != null);
                request.setAttribute("canBecomeReferent", canBecomeReferent);
                doc = ((Documents) nuxeoController.executeNuxeoCommand(new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
            } else {
                final DirectoryPerson person = (DirectoryPerson) request.getAttribute(Constants.ATTR_LOGGED_PERSON);
                nuxeoController.setDisplayLiveVersion("1");
                NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext(request, response, getPortletContext(), pathAct);
                doc = ((Documents) nuxeoController.executeNuxeoCommand(new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
                nuxeoController.executeNuxeoCommand(new BecomeReferentCommand(person.getUid(), level, doc));
                documentContext = NuxeoController.getDocumentContext(request, response, getPortletContext(), pathAct);
                doc = ((Documents) nuxeoController.executeNuxeoCommand(new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
            }


            act = buildActivite(request, response, doc, nuxeoController);
        }

        if (act != null) {
            returnPage = ACTIVITE_PAGE;
        }
        return returnPage;
    }


    @RequestMapping(params = "action=refreshAfterDelete")
    public String refreshAfterDeleteReferents(RenderRequest request, RenderResponse response, PortletSession session) throws Exception {
        String returnPage = ERROR_PAGE;

        ActiviteBean act = null;
        final PortalWindow window = WindowFactory.getWindow(request);
        final String pathAct = window.getProperty(PIA_CMS_URI);
        final NuxeoController nuxeoController = new NuxeoController(request, response, portletContext);

        nuxeoController.setDisplayLiveVersion("1");
        NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext(request, response, getPortletContext(), pathAct);
        Document doc = ((Documents) nuxeoController.executeNuxeoCommand(new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
        doc = (Document) nuxeoController.executeNuxeoCommand(new DeleteReferentCommand(request.getParameter("selectedUid"), doc));
        final Document liveDoc = (Document) nuxeoController.executeNuxeoCommand(new CtrlPermissionCommand("aspire", doc, null));
        final Boolean canBecomeReferent = liveDoc != null;
        request.setAttribute("canBecomeReferent", canBecomeReferent);

        documentContext = NuxeoController.getDocumentContext(request, response, getPortletContext(), pathAct);
        doc = ((Documents) nuxeoController.executeNuxeoCommand(new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
        act = buildActivite(request, response, doc, nuxeoController);
        if (act != null) {
            returnPage = ACTIVITE_PAGE;
        }
        return returnPage;

    }

    @ActionMapping(params = "action=becomeReferent")
    public void levelSelected(@ModelAttribute ReferentBean refForm, BindingResult result, ActionResponse response, ActionRequest request, PortletSession session)
            throws ParseException {

        final String level = refForm.getLevelSelected();
        response.setRenderParameter("levelSelected", level);
        response.setRenderParameter("action", "default");

    }


    @ActionMapping(params = "action=deleteReferent")
    public void deleteReferent(@RequestParam String uid, ActionResponse response, ActionRequest request, PortletSession session) throws ParseException {

        response.setRenderParameter("selectedUid", uid);
        response.setRenderParameter("action", "refreshAfterDelete");
    }

    @ResourceMapping(value = "exportPDF")
    public void exportPdf(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {

        final PortalWindow window = WindowFactory.getWindow(resourceRequest);
        final String pathAct = window.getProperty(PIA_CMS_URI);

        if (StringUtils.isNotBlank(pathAct)) {
            final NuxeoController nuxeoController = new NuxeoController(resourceRequest, resourceResponse, portletContext);
            final NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext(resourceRequest, resourceResponse, getPortletContext(), pathAct);
            Document doc = ((Documents) nuxeoController.executeNuxeoCommand(new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);

            try {
                exportService.writePdf(resourceRequest, resourceResponse, getPortletContext(), commonInitialization(resourceRequest, doc, nuxeoController));
            } catch (Exception e) {
                throw new PortletException(e);
            }
        }
    }

    @ResourceMapping
    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse, PortletSession session) throws PortletException, IOException {

        super.serveResource(resourceRequest, resourceResponse);

    }


    // #3858 ENVOI DE MAIL
    @ActionMapping(params = "action=toContact")
    public void sendMail(@ModelAttribute ReferentBean refForm, BindingResult result, ActionResponse response, ActionRequest request, PortletSession session) {


        final DirectoryPerson person = (DirectoryPerson) request.getAttribute(Constants.ATTR_LOGGED_PERSON);

        // Récupération des propriétés systemes (configurés dans le portal.properties).
        final Properties props = System.getProperties();

        final Session mailSession = Session.getInstance(props, null);

        // Nouveau message
        final MimeMessage msg = new MimeMessage(mailSession);

        // -- Set the FROM and TO fields --
        try {
            msg.setFrom(new InternetAddress(person.getEmail()));

            msg.setSubject(refForm.getSubject(), "UTF-8");

            final String mailDestinataire = refForm.getEmail();

            msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(mailDestinataire, false));

            final Multipart mp = new MimeMultipart();
            final MimeBodyPart txtPart = new MimeBodyPart();
            txtPart.setText(refForm.getBodyMail(), "UTF-8");
            mp.addBodyPart(txtPart);

            msg.setContent(mp);

            msg.setSentDate(new Date());

            final SMTPTransport t = (SMTPTransport) mailSession.getTransport();

            t.connect();
            t.sendMessage(msg, msg.getAllRecipients());
            t.close();
        } catch (final AddressException e) {
            logger.error("erreur envoi mail", e);
        } catch (final MessagingException e) {
            logger.error("erreur envoi mail", e);
        }

    }


    @Override
    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    @Override
    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    private ActiviteBean buildActivite(RenderRequest request, RenderResponse response, Document doc, NuxeoController nuxeoCtl) throws Exception,
            CMSException, UnsupportedEncodingException {


        final ActiviteBean act = commonInitialization(request, doc, nuxeoCtl);

        // stat
        final String stats = System.getProperty("stats.enable");
        if (StringUtils.equalsIgnoreCase(stats, "true")) {
            final String idDun = doc.getPath().substring(0, doc.getPath().lastIndexOf('/'));
            final NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext(request, response, getPortletContext(), idDun);
            final Document dun = documentContext.getDoc();
            String dunName = dun.getString("dun:subtitle");
            if (dunName == null) {
                dunName = dun.getTitle();
            }
            dunName = dunName.trim();
            act.setDun(dunName);
        }

        // Comments
        // List<CommentDTO> comments = (List<CommentDTO>) nuxeoCtl.executeNuxeoCommand(new GetCommentsCommand(liveDoc));
        // act.setComments(comments);

        request.setAttribute("activity", act);

        final VocabularyEntry vocNivRef = VocabularyHelper.getVocabularyEntry(nuxeoCtl, "unu_niveauReferent");
        final Collection<VocabularyEntry> childrenValue = vocNivRef.getChildren().values();

        request.setAttribute("voc", childrenValue);
        request.setAttribute("refForm", new ReferentBean());

        nuxeoCtl.setCurrentDoc(doc);
        nuxeoCtl.insertContentMenuBarItems();

        return act;
    }


    private ActiviteBean commonInitialization(PortletRequest request, Document doc, NuxeoController nuxeoCtl) throws Exception {
        final Principal principal = request.getUserPrincipal();
        final ActiviteBean act = convertNuxeoDocToActiviteBean(doc, nuxeoCtl, principal.getName());

        // permalien viaeduc
        if (StringUtils.isNotBlank(doc.getString("unum:groupeViaeduc"))) {
            final String link = (String) nuxeoCtl.executeNuxeoCommand(new PermalinkCommand("viaeduclink", doc));
            act.setViaeduc(link);
        }

        // réseaux sociaux
        if (act.getLstReferent1() != null) {
            for (ReferentBean referent : act.getLstReferent1()) {
                buildSocialNetworks(nuxeoCtl, referent);
            }
        }
        if (act.getLstReferent2() != null) {
            for (ReferentBean referent : act.getLstReferent2()) {
                buildSocialNetworks(nuxeoCtl, referent);
            }
        }
        if (act.getLstReferent3() != null) {
            for (ReferentBean referent : act.getLstReferent3()) {
                buildSocialNetworks(nuxeoCtl, referent);
            }

        }
        return act;
    }


    private void buildSocialNetworks(NuxeoController nuxeoCtl, ReferentBean referent) {
        Document userProfile = (Document) nuxeoCtl.executeNuxeoCommand(new GetUserProfileCommand(referent.getUid()));

        PropertyList socialnetworks = userProfile.getProperties().getList("ottceup:socialnetworks");
        if (socialnetworks != null) {
            for (Object socialnetworkO : socialnetworks.list()) {
                PropertyMap socialnetworkM = (PropertyMap) socialnetworkO;
                referent.getSocialnetworks().add(new LinkBean(socialnetworkM.getString("type"), socialnetworkM.getString("url")));
            }
        }
    }


    private ActiviteBean convertNuxeoDocToActiviteBean(Document doc, NuxeoController nxController, String uidCurrent) throws Exception {
        final ActiviteBean res = new ActiviteBean();

        res.setId(doc.getId());
        String label = VocabularyHelper.getVocabularyLabel(nxController, "unu_niveau", doc.getString("unum:niv"));
        res.setLevel(label);
        label = VocabularyHelper.getVocabularyLabel(nxController, "unu_duree", doc.getString("unum:duree"));
        res.setDuration(label);
        label = VocabularyHelper.getVocabularyLabel(nxController, "unu_transferabilite", doc.getString("acrp:transferabilite"));
        res.setTransferability(label);
        res.setSummary(doc.getProperties().getString("unum:resume"));
        res.setScenario(toHtml(nxController, doc.getProperties().getString("unum:scenario")));
        res.setTrap(toHtml(nxController, doc.getProperties().getString("unum:piege")));
        res.setAnalysis(toHtml(nxController, doc.getProperties().getString("unum:analyse")));
        res.setTitle(doc.getTitle());
        res.setLastContributor(doc.getProperties().getString("dc:lastContributor"));
        final String uidAuthor = doc.getProperties().getString("dc:creator");
        if (StringUtils.isNotBlank(uidAuthor)) {
            DirectoryPerson person = getDirectoryService().getPerson(uidAuthor);
            if (person != null) {
                res.setAuthor(StringUtils.defaultString(person.getDisplayName()));
            } else {
                res.setAuthor(uidAuthor);
            }
        }

        res.setExperitheque(doc.getProperties().getBoolean("unum:experitheque"));
        res.setUrlExpe(doc.getProperties().getString("unum:urlExpe"));

        PropertyList lst = doc.getProperties().getList("acrp:disciplines");
        res.setLstDisciplines(protertyStringToListString(lst));

        lst = (PropertyList) doc.getProperties().get("acrp:niveauxEducatifs");
        res.setLstPublics(protertyStringToListString("carto_publicVise", lst, nxController));

        lst = (PropertyList) doc.getProperties().get("acrp:naturesPedagogiques");
        res.setLstPedagogicals(protertyStringToListString("unu_naturepeda", lst, nxController));

        lst = (PropertyList) doc.getProperties().get("unum:parcours");
        res.setLstParcours(protertyStringToListString(lst));

        lst = (PropertyList) doc.getProperties().get("unum:axe");
        res.setLstAxes(protertyStringToListString(lst));

        lst = (PropertyList) doc.getProperties().get("acrp:pratique");
        res.setLstPractices(protertyStringToListString("unu_pratiques", lst, nxController));

        lst = (PropertyList) doc.getProperties().get("acrp:cadresUtilisations");
        res.setLstCadres(protertyStringToListString("unu_modalite", lst, nxController));


        lst = (PropertyList) doc.getProperties().get("acrp:lieu");
        res.setLstPlaces(protertyStringToListString("unu_lieu", lst, nxController));

        lst = (PropertyList) doc.getProperties().get("acrp:outils");
        res.setLstTools(protertyStringToListString(lst));


        lst = (PropertyList) doc.getProperties().get("acrp:competences");
        res.setLstCompetence(protertyStringToListString(null, lst, nxController));
        lst = (PropertyList) doc.getProperties().get("unum:logicielLocal");
        res.setLstSoftware(protertyStringToListString(null, lst, nxController));

        lst = (PropertyList) doc.getProperties().get("unum:logicielInternet");
        final List<LinkBean> lstESoftware = new ArrayList<LinkBean>();
        for (int i = 0; i < lst.size(); i++) {
            lstESoftware.add(new LinkBean(lst.getMap(i).getString("name"), lst.getMap(i).getString("url")));
        }
        res.setLstESoftware(lstESoftware);

        lst = (PropertyList) doc.getProperties().get("unum:referents");
        List<ReferentBean> lstRefLevel1 = null;
        List<ReferentBean> lstRefLevel2 = null;

        for (final Object referentsO : lst.list()) {
            final PropertyMap referentMap = (PropertyMap) referentsO;

            if ((referentMap.get("owner") != null) && referentMap.getBoolean("owner")) {
                res.setOwner(referentMap.getString("uid"));
            }

            final Integer iLevel = new Integer(referentMap.getString("niveau"));
            switch (iLevel) {
                case 1:
                    if (lstRefLevel1 == null) {
                        lstRefLevel1 = new ArrayList<ReferentBean>();
                        res.setLabelReferent1(VocabularyHelper.getVocabularyLabel(nxController, "unu_niveauReferent", "1"));
                    }
                    lstRefLevel1.add(new ReferentBean(referentMap, uidCurrent, uidAuthor));
                    break;
                case 2:
                    if (lstRefLevel2 == null) {
                        lstRefLevel2 = new ArrayList<ReferentBean>();
                        res.setLabelReferent2(VocabularyHelper.getVocabularyLabel(nxController, "unu_niveauReferent", "2"));
                    }
                    lstRefLevel2.add(new ReferentBean(referentMap, uidCurrent, uidAuthor));
                    break;
                case 3:
                    // fusion des listes ref2 et ref3 qui ne doivent plus être différentiées sur le portail
                    if (lstRefLevel2 == null) {
                        lstRefLevel2 = new ArrayList<ReferentBean>();
                        res.setLabelReferent3(VocabularyHelper.getVocabularyLabel(nxController, "unu_niveauReferent", "3"));
                    }
                    lstRefLevel2.add(new ReferentBean(referentMap, uidCurrent, uidAuthor));
                    break;
            }
        }

        res.setLstReferent1(lstRefLevel1);
        res.setLstReferent2(lstRefLevel2);

        final PropertyMap map = doc.getProperties().getMap("ttc:vignette");
        String urlVignette;
        if (map != null) {
            urlVignette = nxController.createFileLink(doc, "ttc:vignette");
            res.setUrlVignette("<img class=\"kartoun-titre-img-float\" src=\"" + urlVignette + "\" />");
        } else {
            urlVignette = getPictureLinkByWebId(nxController, VIGNETTE_DEFAUT_WEBID);
            res.setUrlVignette("<img class=\"kartoun-titre-img-float img-responsive\" src=\"" + urlVignette + "\" />");
        }
        res.setDatePublication(doc.getDate("dc:issued"));
        res.setDateModification(doc.getDate("dc:modified"));
        // pour les stats
        if (doc.getPath().endsWith(".proxy")) {
            res.setDraft(false);
        } else {
            res.setDraft(true);
        }

        // pjs
        final PropertyList files = doc.getProperties().getList("files:files");
        if ((null != files) && !files.isEmpty()) {
            int idx = 0;
            final HashMap<String, String> mapPj = new HashMap<String, String>(files.size());
            while (idx < files.size()) {
                mapPj.put(files.getMap(idx).getString("filename"), nxController.createAttachedFileLink(doc.getPath(), String.valueOf(idx)));
                idx++;
            }
            res.setPj(mapPj);
        }

        return res;
    }

    private String toHtml(NuxeoController nuxeoController, String value){
    	if(value != null){
    		return nuxeoController.transformHTMLContent(value);
    	}
    	return StringUtils.EMPTY;
    }

    private String getPictureLinkByWebId(NuxeoController nuxeoController, String webId) {
        final String vignetteGeneriquePath = NuxeoController.webIdToFetchPath(webId);
        final ICMSService cmsService = NuxeoController.getCMSService();
        String vignetteCmsPath;
        try {
            vignetteCmsPath = cmsService.adaptWebPathToCms(nuxeoController.getCMSCtx(), vignetteGeneriquePath);
        } catch (CMSException e) {
            return StringUtils.EMPTY;
        }
        return nuxeoController.createPictureLink(vignetteCmsPath, "Original");
    }

    private List<String> protertyStringToListString(String vocabularyName, PropertyList lst, NuxeoController nxController) throws Exception {

        final List<String> lstString = new ArrayList<String>();

        if (lst != null) {
            for (Object propertyO : lst.list()) {
                String property = (String) propertyO;
                if (vocabularyName != null) {
                    String[] keys = StringUtils.split(property, '/');
                    StringBuilder vocabSb = new StringBuilder();
                    for (int i = 0; i < keys.length; i++) {
                        if (i > 0) {
                            vocabSb.append(" / ");
                        }
                        String vocabularyLabel = VocabularyHelper.getVocabularyLabel(nxController, vocabularyName, keys[i]);
                        if (vocabularyLabel != null) {
                            vocabSb.append(vocabularyLabel);
                        } else {
                            vocabSb.append(keys[i]);
                        }
                    }
                    lstString.add(vocabSb.toString());
                } else {
                    lstString.add(property);
                }
            }
        }
        return lstString;
    }

    private List<String> protertyStringToListString(PropertyList lst) {
        final List<String> lstString = new ArrayList<String>();

        if (lst != null) {
            for (Object propertyO : lst.list()) {
                String property = (String) propertyO;
                lstString.add(property);
            }
        }
        return lstString;
    }

}
