package fr.toutatice.cartoun.portlet.detailactivite.util.pdf;

import com.itextpdf.text.Image;
import com.itextpdf.tool.xml.pipeline.html.AbstractImageProvider;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;


/**
 * implementation de AbstractImageProvider de Itext permettant d'insérer des images lors de la conversion html vers pdf
 * ne reconnait que les liens binary servlet
 *
 * @author dorian
 */
public class NuxeoImageProvider extends AbstractImageProvider {

    private NuxeoController nuxeoController;


    public NuxeoImageProvider(NuxeoController nuxeoController) {
        this.nuxeoController = nuxeoController;
    }

    @Override
    public String getImageRootPath() {
        return null;
    }

    @Override
    public Image retrieve(final String src) {
        Image img = super.retrieve(src);
        if (img == null) {
            try {
                byte[] data = PDFUtil.getImage(src, nuxeoController);
                img = Image.getInstance(data);
                super.store(src, img);
            } catch (Exception e) {
            }
        }
        return img;
    }



}
