/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.portlet.detailactivite.service.impl;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.ElementList;
import fr.toutatice.cartoun.portlet.detailactivite.bean.ActiviteBean;
import fr.toutatice.cartoun.portlet.detailactivite.bean.LinkBean;
import fr.toutatice.cartoun.portlet.detailactivite.bean.ReferentBean;
import fr.toutatice.cartoun.portlet.detailactivite.service.IExportService;
import fr.toutatice.cartoun.portlet.detailactivite.util.VocabularyUtil;
import fr.toutatice.cartoun.portlet.detailactivite.util.pdf.ActiviteFooter;
import fr.toutatice.cartoun.portlet.detailactivite.util.pdf.PDFUtil;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.OutputStream;
import java.util.Iterator;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.springframework.stereotype.Service;

@Service
public class ExportServiceImpl
implements IExportService {
    protected IBundleFactory bundleFactory;

    public ExportServiceImpl() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void writePdf(ResourceRequest request, ResourceResponse response, PortletContext portletContext, ActiviteBean activite) throws PortletException {
        Document document = new Document();
        ByteArrayOutputStream baos = null;
        try {
            String tool;
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, portletContext);
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            baos = new ByteArrayOutputStream();
            document.setMargins(document.leftMargin(), document.rightMargin(), document.topMargin(), document.bottomMargin() + 20.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            Font titleFont = FontFactory.getFont((String)"Helvetica", (float)18.0f, (int)0);
            Font chapterFont = FontFactory.getFont((String)"Helvetica", (float)14.0f, (int)0);
            Font paragraphFont = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)0);
            Font paragraphFontBold = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)1);
            writer.setPageEvent((PdfPageEvent)new ActiviteFooter(paragraphFont, paragraphFontBold, portletContext, activite, bundle));
            PdfPTable headTable = new PdfPTable(2);
            headTable.setWidths(new float[]{1.0f, 2.0f});
            Image vignette = Image.getInstance((byte[])PDFUtil.getImage((String)activite.getUrlVignette(), (NuxeoController)nuxeoController));
            vignette.scaleToFit(130.0f, 70.0f);
            PdfPCell cell = new PdfPCell(vignette);
            cell.setBorder(0);
            cell.setHorizontalAlignment(0);
            cell.setRightIndent(20.0f);
            headTable.addCell(cell);
            cell = new PdfPCell(new Phrase(activite.getTitle(), titleFont));
            cell.setBorder(0);
            headTable.addCell(cell);
            document.add((Element)headTable);
            document.add((Element)Chunk.NEWLINE);
            Paragraph contacts = new Paragraph(bundle.getString("label.contact"), chapterFont);
            if (activite.getLstReferent1() != null && !activite.getLstReferent1().isEmpty()) {
                contacts.add((Element)Chunk.NEWLINE);
                contacts.add((Element)new Phrase(bundle.getString("label.contact.niveau.1") + " : ", paragraphFontBold));
                for (ReferentBean referent : activite.getLstReferent1()) {
                    contacts.add((Element)Chunk.NEWLINE);
                    contacts.add((Element)Chunk.TABBING);
                    contacts.add((Element)new Chunk(referent.getIdentite(), paragraphFont));
                }
            }
            if (activite.getLstReferent2() != null) {
                contacts.add((Element)Chunk.NEWLINE);
                contacts.add((Element)new Phrase(bundle.getString("label.contact.niveau.2") + " : ", paragraphFontBold));
                for (ReferentBean referent : activite.getLstReferent2()) {
                    contacts.add((Element)Chunk.NEWLINE);
                    contacts.add((Element)Chunk.TABBING);
                    contacts.add((Element)new Chunk(referent.getIdentite(), paragraphFont));
                }
            }
            if (activite.getLstReferent3() != null) {
                contacts.add((Element)Chunk.NEWLINE);
                contacts.add((Element)new Phrase(bundle.getString("label.contact.niveau.3") + " : ", paragraphFontBold));
                for (ReferentBean referent : activite.getLstReferent3()) {
                    contacts.add((Element)Chunk.NEWLINE);
                    contacts.add((Element)Chunk.TABBING);
                    contacts.add((Element)new Chunk(referent.getIdentite(), paragraphFont));
                }
            }
            document.add((Element)contacts);
            document.add((Element)Chunk.NEWLINE);
            if (StringUtils.isNotBlank((String)activite.getViaeduc())) {
                Paragraph viaeduc = new Paragraph(bundle.getString("label.viaeduc"), chapterFont);
                viaeduc.add((Element)Chunk.TABBING);
                viaeduc.add((Element)new Chunk(activite.getViaeduc(), paragraphFont));
                document.add((Element)viaeduc);
                document.add((Element)Chunk.NEWLINE);
            }
            if (StringUtils.isNotBlank((String)activite.getUrlExpe())) {
                Paragraph expe = new Paragraph(bundle.getString("label.experitheque"), chapterFont);
                expe.add((Element)Chunk.TABBING);
                expe.add((Element)new Chunk(activite.getUrlExpe(), paragraphFont));
                document.add((Element)expe);
                document.add((Element)Chunk.NEWLINE);
            }
            Phrase reperes = new Phrase(bundle.getString("label.reperes"), chapterFont);
            document.add((Element)reperes);
            PdfPTable reperesTable = new PdfPTable(2);
            cell = new PdfPCell(new Phrase(bundle.getString("label.reperes.principal"), paragraphFontBold));
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setRightIndent(20.0f);
            reperesTable.addCell(cell);
            cell = new PdfPCell(new Phrase(VocabularyUtil.getVocabularyEntry((NuxeoController)nuxeoController, (String)"carto_reperes", (String)activite.getReperePrincipal()), paragraphFont));
            cell.setBorder(0);
            reperesTable.addCell(cell);
            if (StringUtils.isNotBlank((String)activite.getRepereOther())) {
                cell = new PdfPCell(new Phrase(bundle.getString("label.reperes.other"), paragraphFontBold));
                cell.setBorder(0);
                cell.setHorizontalAlignment(2);
                cell.setRightIndent(20.0f);
                reperesTable.addCell(cell);
                cell = new PdfPCell(new Phrase(VocabularyUtil.getVocabularyEntry((NuxeoController)nuxeoController, (String)"carto_reperes", (String)activite.getRepereOther()), paragraphFont));
                cell.setBorder(0);
                reperesTable.addCell(cell);
            }
            document.add((Element)reperesTable);
            document.add((Element)Chunk.NEWLINE);
            Phrase parcours = new Phrase(bundle.getString("label.titre.parcoursAxes"), chapterFont);
            document.add((Element)parcours);
            PdfPTable parcoursTable = new PdfPTable(2);
            cell = new PdfPCell(new Phrase(bundle.getString("label.parcours"), paragraphFontBold));
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setRightIndent(20.0f);
            parcoursTable.addCell(cell);
            if (activite.getLstParcours() == null || activite.getLstParcours().size() == 0) {
                cell = new PdfPCell(new Phrase(bundle.getString("value.parcours.null"), paragraphFont));
                cell.setBorder(0);
                parcoursTable.addCell(cell);
            } else {
                Iterator parcoursIterator = activite.getLstParcours().iterator();
                while (parcoursIterator.hasNext()) {
                    String parcour = (String)parcoursIterator.next();
                    cell = new PdfPCell(new Phrase(VocabularyUtil.getVocabularyEntry((NuxeoController)nuxeoController, (String)"carto_parcours", (String)parcour), paragraphFont));
                    cell.setBorder(0);
                    parcoursTable.addCell(cell);
                    if (!parcoursIterator.hasNext()) continue;
                    parcoursTable.addCell(PDFUtil.emptyCell());
                }
            }
            cell = new PdfPCell(new Phrase(bundle.getString("label.axes"), paragraphFontBold));
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setRightIndent(20.0f);
            parcoursTable.addCell(cell);
            if (activite.getLstAxes() == null || activite.getLstAxes().size() == 0) {
                cell = new PdfPCell(new Phrase(bundle.getString("value.axes.null"), paragraphFont));
                cell.setBorder(0);
                parcoursTable.addCell(cell);
            } else {
                Iterator axesIterator = activite.getLstAxes().iterator();
                while (axesIterator.hasNext()) {
                    String axe = (String)axesIterator.next();
                    cell = new PdfPCell(new Phrase(VocabularyUtil.getVocabularyEntry((NuxeoController)nuxeoController, (String)"carto_axes", (String)axe), paragraphFont));
                    cell.setBorder(0);
                    parcoursTable.addCell(cell);
                    if (!axesIterator.hasNext()) continue;
                    parcoursTable.addCell(PDFUtil.emptyCell());
                }
            }
            document.add((Element)parcoursTable);
            document.add((Element)Chunk.NEWLINE);
            Phrase disciplines = new Phrase(bundle.getString("label.discipline.public"), chapterFont);
            document.add((Element)disciplines);
            PdfPTable disciplineTable = new PdfPTable(2);
            cell = new PdfPCell(new Phrase(bundle.getString("label.discipline"), paragraphFontBold));
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setRightIndent(20.0f);
            disciplineTable.addCell(cell);
            Iterator disciplinesIterator = activite.getLstDisciplines().iterator();
            while (disciplinesIterator.hasNext()) {
                String discipline = (String)disciplinesIterator.next();
                cell = new PdfPCell(new Phrase(VocabularyUtil.getVocabularyEntry((NuxeoController)nuxeoController, (String)"disciplines", (String)discipline), paragraphFont));
                cell.setBorder(0);
                disciplineTable.addCell(cell);
                if (!disciplinesIterator.hasNext()) continue;
                disciplineTable.addCell(PDFUtil.emptyCell());
            }
            cell = new PdfPCell(new Phrase(bundle.getString("label.public"), paragraphFontBold));
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setRightIndent(20.0f);
            disciplineTable.addCell(cell);
            Iterator publicsIterator = activite.getLstPublics().iterator();
            while (publicsIterator.hasNext()) {
                String publicS = (String)publicsIterator.next();
                cell = new PdfPCell(new Phrase(publicS, paragraphFont));
                cell.setBorder(0);
                disciplineTable.addCell(cell);
                if (!publicsIterator.hasNext()) continue;
                disciplineTable.addCell(PDFUtil.emptyCell());
            }
            document.add((Element)disciplineTable);
            document.add((Element)Chunk.NEWLINE);
            Phrase description = new Phrase(bundle.getString("label.description"), chapterFont);
            document.add((Element)description);
            PdfPTable descriptionTable = new PdfPTable(2);
            cell = new PdfPCell(new Phrase(bundle.getString("label.niveau"), paragraphFontBold));
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setRightIndent(20.0f);
            descriptionTable.addCell(cell);
            cell = StringUtils.isNotBlank((String)activite.getLevel()) ? new PdfPCell(new Phrase(activite.getLevel(), paragraphFont)) : new PdfPCell(new Phrase(bundle.getString("value.niveau.null"), paragraphFont));
            cell.setBorder(0);
            descriptionTable.addCell(cell);
            cell = new PdfPCell(new Phrase(bundle.getString("label.pratique"), paragraphFontBold));
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setRightIndent(20.0f);
            descriptionTable.addCell(cell);
            if (activite.getLstPractices() == null || activite.getLstPractices().size() == 0) {
                cell = new PdfPCell(new Phrase(bundle.getString("value.pratique.null"), paragraphFont));
                cell.setBorder(0);
                descriptionTable.addCell(cell);
            } else {
                Iterator practicesIterator = activite.getLstPractices().iterator();
                while (practicesIterator.hasNext()) {
                    String practice = (String)practicesIterator.next();
                    cell = new PdfPCell(new Phrase(practice, paragraphFont));
                    cell.setBorder(0);
                    descriptionTable.addCell(cell);
                    if (!practicesIterator.hasNext()) continue;
                    descriptionTable.addCell(PDFUtil.emptyCell());
                }
            }
            cell = new PdfPCell(new Phrase(bundle.getString("label.outils"), paragraphFontBold));
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setRightIndent(20.0f);
            descriptionTable.addCell(cell);
            if (activite.getLstTools() == null || activite.getLstTools().size() == 0) {
                cell = new PdfPCell(new Phrase(bundle.getString("value.outils.null"), paragraphFont));
                cell.setBorder(0);
                descriptionTable.addCell(cell);
            } else {
                Iterator toolsIterator = activite.getLstTools().iterator();
                while (toolsIterator.hasNext()) {
                    tool = (String)toolsIterator.next();
                    cell = new PdfPCell(new Phrase(VocabularyUtil.getVocabularyEntry((NuxeoController)nuxeoController, (String)"unu_outils", (String)tool), paragraphFont));
                    cell.setBorder(0);
                    descriptionTable.addCell(cell);
                    if (!toolsIterator.hasNext()) continue;
                    descriptionTable.addCell(PDFUtil.emptyCell());
                }
            }
            if (StringUtils.isNotBlank((String)activite.getDuration())) {
                cell = new PdfPCell(new Phrase(bundle.getString("label.duree"), paragraphFontBold));
                cell.setBorder(0);
                cell.setHorizontalAlignment(2);
                cell.setRightIndent(20.0f);
                descriptionTable.addCell(cell);
                cell = new PdfPCell(new Phrase(activite.getDuration(), paragraphFont));
                cell.setBorder(0);
                descriptionTable.addCell(cell);
            }
            cell = new PdfPCell(new Phrase(bundle.getString("label.nature"), paragraphFontBold));
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setRightIndent(20.0f);
            descriptionTable.addCell(cell);
            Iterator pdgIterator = activite.getLstPedagogicals().iterator();
            while (pdgIterator.hasNext()) {
                tool = (String)pdgIterator.next();
                cell = new PdfPCell(new Phrase(tool, paragraphFont));
                cell.setBorder(0);
                descriptionTable.addCell(cell);
                if (!pdgIterator.hasNext()) continue;
                descriptionTable.addCell(PDFUtil.emptyCell());
            }
            cell = new PdfPCell(new Phrase(bundle.getString("label.modalite"), paragraphFontBold));
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setRightIndent(20.0f);
            descriptionTable.addCell(cell);
            Iterator cadresIterator = activite.getLstCadres().iterator();
            while (cadresIterator.hasNext()) {
                String cadre = (String)cadresIterator.next();
                cell = new PdfPCell(new Phrase(cadre, paragraphFont));
                cell.setBorder(0);
                descriptionTable.addCell(cell);
                if (!cadresIterator.hasNext()) continue;
                descriptionTable.addCell(PDFUtil.emptyCell());
            }
            cell = new PdfPCell(new Phrase(bundle.getString("label.lieu"), paragraphFontBold));
            cell.setBorder(0);
            cell.setHorizontalAlignment(2);
            cell.setRightIndent(20.0f);
            descriptionTable.addCell(cell);
            Iterator placesIterator = activite.getLstPlaces().iterator();
            while (placesIterator.hasNext()) {
                String place = (String)placesIterator.next();
                cell = new PdfPCell(new Phrase(place, paragraphFont));
                cell.setBorder(0);
                descriptionTable.addCell(cell);
                if (!placesIterator.hasNext()) continue;
                descriptionTable.addCell(PDFUtil.emptyCell());
            }
            if (activite.getLstSoftware() != null && !activite.getLstSoftware().isEmpty()) {
                cell = new PdfPCell(new Phrase(bundle.getString("label.logiciel"), paragraphFontBold));
                cell.setBorder(0);
                cell.setHorizontalAlignment(2);
                cell.setRightIndent(20.0f);
                descriptionTable.addCell(cell);
                Iterator softwaresIterator = activite.getLstSoftware().iterator();
                while (softwaresIterator.hasNext()) {
                    String software = (String)softwaresIterator.next();
                    cell = new PdfPCell(new Phrase(software, paragraphFont));
                    cell.setBorder(0);
                    descriptionTable.addCell(cell);
                    if (!softwaresIterator.hasNext()) continue;
                    descriptionTable.addCell(PDFUtil.emptyCell());
                }
            }
            if (activite.getLstESoftware() != null && !activite.getLstESoftware().isEmpty()) {
                cell = new PdfPCell(new Phrase(bundle.getString("label.elogiciel"), paragraphFontBold));
                cell.setBorder(0);
                cell.setHorizontalAlignment(2);
                cell.setRightIndent(20.0f);
                descriptionTable.addCell(cell);
                Iterator esoftwaresIterator = activite.getLstESoftware().iterator();
                while (esoftwaresIterator.hasNext()) {
                    LinkBean esoftware = (LinkBean)esoftwaresIterator.next();
                    cell = new PdfPCell(new Phrase(esoftware.getName(), paragraphFont));
                    cell.setBorder(0);
                    descriptionTable.addCell(cell);
                    if (!esoftwaresIterator.hasNext()) continue;
                    descriptionTable.addCell(PDFUtil.emptyCell());
                }
            }
            if (StringUtils.isNotBlank((String)activite.getTransferability())) {
                cell = new PdfPCell(new Phrase(bundle.getString("label.transfert"), paragraphFontBold));
                cell.setBorder(0);
                cell.setHorizontalAlignment(2);
                cell.setRightIndent(20.0f);
                descriptionTable.addCell(cell);
                cell = new PdfPCell(new Phrase(activite.getTransferability(), paragraphFont));
                cell.setBorder(0);
                descriptionTable.addCell(cell);
            }
            if (activite.getLstCompetence() != null && !activite.getLstCompetence().isEmpty()) {
                cell = new PdfPCell(new Phrase(bundle.getString("label.competence"), paragraphFontBold));
                cell.setBorder(0);
                cell.setHorizontalAlignment(2);
                cell.setRightIndent(20.0f);
                descriptionTable.addCell(cell);
                Iterator competenceIterator = activite.getLstCompetence().iterator();
                while (competenceIterator.hasNext()) {
                    String competence = (String)competenceIterator.next();
                    cell = new PdfPCell(new Phrase(competence, paragraphFont));
                    cell.setBorder(0);
                    descriptionTable.addCell(cell);
                    if (!competenceIterator.hasNext()) continue;
                    descriptionTable.addCell(PDFUtil.emptyCell());
                }
            }
            document.add((Element)descriptionTable);
            document.add((Element)Chunk.NEWLINE);
            Phrase resume = new Phrase(bundle.getString("label.resume"), chapterFont);
            document.add((Element)resume);
            if (StringUtils.isNotBlank((String)activite.getSummary())) {
                Paragraph resumeContent = new Paragraph(activite.getSummary(), paragraphFont);
                document.add((Element)resumeContent);
            }
            document.add((Element)Chunk.NEWLINE);
            Phrase scenario = new Phrase(bundle.getString("label.scenario"), chapterFont);
            document.add((Element)scenario);
            if (StringUtils.isNotBlank((String)activite.getScenario())) {
                String scenarioS = PDFUtil.sanitizeHTML((String)activite.getScenario());
                ElementList list = PDFUtil.parseStringHTMLToElements((String)scenarioS, (NuxeoController)nuxeoController);
                for (Element element : list) {
                    document.add(element);
                }
            }
            document.add((Element)Chunk.NEWLINE);
            Phrase analyse = new Phrase(bundle.getString("label.analyse"), chapterFont);
            document.add((Element)analyse);
            if (StringUtils.isNotBlank((String)activite.getAnalysis())) {
                String analysis = PDFUtil.sanitizeHTML((String)activite.getAnalysis());
                ElementList elementList = PDFUtil.parseStringHTMLToElements((String)analysis, (NuxeoController)nuxeoController);
                for (Element element : elementList) {
                    document.add(element);
                }
            }
            document.add((Element)Chunk.NEWLINE);
            Phrase pieges = new Phrase(bundle.getString("label.pieges"), chapterFont);
            document.add((Element)pieges);
            if (StringUtils.isNotBlank((String)activite.getTrap())) {
                String trap = PDFUtil.sanitizeHTML((String)activite.getTrap());
                ElementList list = PDFUtil.parseStringHTMLToElements((String)trap, (NuxeoController)nuxeoController);
                for (Element element : list) {
                    document.add(element);
                }
            }
            document.add((Element)Chunk.NEWLINE);
            document.addTitle(activite.getTitle());
            document.close();
            response.setContentType("application/pdf");
            response.setProperty("Content-disposition", "inline; filename=\"" + activite.getTitle() + ".pdf" + "\"");
            response.setContentLength(baos.size());
            baos.writeTo(response.getPortletOutputStream());
            baos.flush();
            baos.close();
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }
}

