/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.portlet.detailactivite.util.pdf;

import com.itextpdf.text.Image;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class OsiviaImageCssApplier {
    public Image apply(Image img, Tag tag) {
        String after;
        String before;
        String borderLeftWidth;
        String borderLeftColor;
        String borderBottomWidth;
        String borderBottomColor;
        String borderRightWidth;
        String borderRightColor;
        String borderTopWidth;
        String classes;
        String heightValue;
        Map cssMap = tag.getCSS();
        String widthValue = (String)cssMap.get("width");
        if (widthValue == null) {
            widthValue = (String)tag.getAttributes().get("width");
        }
        if ((heightValue = (String)cssMap.get("height")) == null) {
            heightValue = (String)tag.getAttributes().get("height");
        }
        if (StringUtils.contains((String)(classes = (String)tag.getAttributes().get("class")), (String)"img-responsive") || StringUtils.contains((String)classes, (String)"enlargeable")) {
            img.setScaleToFitLineWhenOverflow(true);
        } else if (widthValue == null) {
            img.setScaleToFitLineWhenOverflow(true);
        } else {
            img.setScaleToFitLineWhenOverflow(false);
        }
        img.setScaleToFitHeight(false);
        CssUtils utils = CssUtils.getInstance();
        float widthInPoints = utils.parsePxInCmMmPcToPt(widthValue);
        float heightInPoints = utils.parsePxInCmMmPcToPt(heightValue);
        if (widthInPoints > 0.0f && heightInPoints > 0.0f) {
            img.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (widthInPoints > 0.0f) {
            heightInPoints = img.getHeight() * widthInPoints / img.getWidth();
            img.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (heightInPoints > 0.0f) {
            widthInPoints = img.getWidth() * heightInPoints / img.getHeight();
            img.scaleAbsolute(widthInPoints, heightInPoints);
        }
        String borderTopColor = (String)cssMap.get("border-top-color");
        if (borderTopColor != null) {
            img.setBorderColorTop(HtmlUtilities.decodeColor((String)borderTopColor));
        }
        if ((borderTopWidth = (String)cssMap.get("border-top-width")) != null) {
            img.setBorderWidthTop(utils.parseValueToPt(borderTopWidth, 1.0f));
        }
        if ((borderRightColor = (String)cssMap.get("border-right-color")) != null) {
            img.setBorderColorRight(HtmlUtilities.decodeColor((String)borderRightColor));
        }
        if ((borderRightWidth = (String)cssMap.get("border-right-width")) != null) {
            img.setBorderWidthRight(utils.parseValueToPt(borderRightWidth, 1.0f));
        }
        if ((borderBottomColor = (String)cssMap.get("border-bottom-color")) != null) {
            img.setBorderColorBottom(HtmlUtilities.decodeColor((String)borderBottomColor));
        }
        if ((borderBottomWidth = (String)cssMap.get("border-bottom-width")) != null) {
            img.setBorderWidthBottom(utils.parseValueToPt(borderBottomWidth, 1.0f));
        }
        if ((borderLeftColor = (String)cssMap.get("border-left-color")) != null) {
            img.setBorderColorLeft(HtmlUtilities.decodeColor((String)borderLeftColor));
        }
        if ((borderLeftWidth = (String)cssMap.get("border-left-width")) != null) {
            img.setBorderWidthLeft(utils.parseValueToPt(borderLeftWidth, 1.0f));
        }
        if ((before = (String)cssMap.get("before")) != null) {
            img.setSpacingBefore(Float.parseFloat(before));
        }
        if ((after = (String)cssMap.get("after")) != null) {
            img.setSpacingAfter(Float.parseFloat(after));
        }
        img.setWidthPercentage(0.0f);
        return img;
    }
}

