/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.portlet.detailactivite.util.pdf;

import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.tool.xml.ElementHandler;
import com.itextpdf.tool.xml.ElementList;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.XMLWorker;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.html.TagProcessorFactory;
import com.itextpdf.tool.xml.html.Tags;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.parser.XMLParserListener;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.end.ElementHandlerPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.pipeline.html.ImageProvider;
import fr.toutatice.cartoun.portlet.detailactivite.util.pdf.NuxeoImageProvider;
import fr.toutatice.cartoun.portlet.detailactivite.util.pdf.OsiviaCssapplier;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.ResourceUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSBinaryContent;

/*
 * Exception performing whole class analysis ignored.
 */
public class PDFUtil {
    private static final Pattern cleanHTMLTags = Pattern.compile("<(OBJECT|object).+\\/(OBJECT|object>)>");
    private static final Pattern imgTagToXhtml = Pattern.compile("(<(img|IMG)[^>]+)(>)");
    private static final Pattern brTagToXhtml = Pattern.compile("(<(br|BR)\\s?\\/?)>");
    private static final Pattern hrTagToXhtml = Pattern.compile("(<(hr|HR)\\s?\\/?)>");
    private static final Pattern PATTERN_TYPE = Pattern.compile("type=([^&]+)&");
    private static final Pattern PATTERN_PATH = Pattern.compile("path=([^&]+)&");
    private static final Pattern PATTERN_INDEX = Pattern.compile("index=([^&]+)&");
    private static final Pattern PATTERN_CONTENT = Pattern.compile("content=([^&]+)&");
    private static final Pattern PATTERN_FIELDNAME = Pattern.compile("fieldName=([^&]+)&");

    private PDFUtil() {
    }

    public static ElementList parseStringHTMLToElements(String stringToParse, NuxeoController nuxeoController) throws IOException {
        StringReader sr = new StringReader(stringToParse);
        ElementList elementList = new ElementList();
        HtmlPipelineContext htmlContext = new HtmlPipelineContext((CssAppliers)new OsiviaCssapplier());
        TagProcessorFactory htmlTagProcessorFactory = Tags.getHtmlTagProcessorFactory();
        htmlContext.setTagFactory(htmlTagProcessorFactory);
        htmlContext.setAcceptUnknown(true);
        htmlContext.setImageProvider((ImageProvider)new NuxeoImageProvider(nuxeoController));
        CSSResolver cssResolver = XMLWorkerHelper.getInstance().getDefaultCssResolver(true);
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, (Pipeline)new HtmlPipeline(htmlContext, (Pipeline)new ElementHandlerPipeline((ElementHandler)elementList, null)));
        XMLWorker worker = new XMLWorker((Pipeline)pipeline, true);
        XMLParser p = new XMLParser((XMLParserListener)worker);
        p.parse((Reader)sr);
        return elementList;
    }

    public static PdfPCell emptyCell() {
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        return cell;
    }

    public static String sanitizeHTML(String htmlToSanitize) {
        Matcher matcher = cleanHTMLTags.matcher(htmlToSanitize);
        String scenarioS = matcher.replaceAll("");
        scenarioS = PDFUtil.patternReplacer((Pattern)imgTagToXhtml, (String)"$1></img>", (String)scenarioS);
        scenarioS = PDFUtil.patternReplacer((Pattern)brTagToXhtml, (String)"$1></br>", (String)scenarioS);
        scenarioS = PDFUtil.patternReplacer((Pattern)hrTagToXhtml, (String)"$1></hr>", (String)scenarioS);
        return scenarioS;
    }

    private static String patternReplacer(Pattern pattern, String replacement, String stringToClean) {
        Matcher matcher = pattern.matcher(stringToClean);
        StringBuffer linkReplacementStack = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(linkReplacementStack, replacement);
        }
        matcher.appendTail(linkReplacementStack);
        return linkReplacementStack.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] getImage(String src, NuxeoController nuxeoController) {
        byte[] byteArray = null;
        InputStream is = null;
        try {
            Matcher matcher = PATTERN_TYPE.matcher(src);
            String type = null;
            if (matcher.find()) {
                type = matcher.group(1);
            }
            matcher = PATTERN_PATH.matcher(src);
            String path = null;
            if (matcher.find()) {
                path = matcher.group(1);
                path = URLDecoder.decode(path, "UTF-8");
            }
            CMSBinaryContent attachedPicture = null;
            if (BinaryDescription.Type.ATTACHED_PICTURE.equals((Object)BinaryDescription.Type.valueOf((String)type))) {
                matcher = PATTERN_INDEX.matcher(src);
                String index = null;
                if (matcher.find()) {
                    index = matcher.group(1);
                }
                attachedPicture = nuxeoController.fetchAttachedPicture(path, index);
            } else if (BinaryDescription.Type.PICTURE.equals((Object)BinaryDescription.Type.valueOf((String)type))) {
                matcher = PATTERN_CONTENT.matcher(src);
                String content = null;
                if (matcher.find()) {
                    content = matcher.group(1);
                }
                attachedPicture = nuxeoController.fetchPicture(path, content);
            } else if (BinaryDescription.Type.FILE.equals((Object)BinaryDescription.Type.valueOf((String)type))) {
                matcher = PATTERN_FIELDNAME.matcher(src);
                String fieldName = null;
                if (matcher.find()) {
                    fieldName = matcher.group(1);
                }
                nuxeoController.setStreamingSupport(true);
                attachedPicture = nuxeoController.fetchFileContent(path, fieldName);
            } else if (BinaryDescription.Type.BLOB.equals((Object)BinaryDescription.Type.valueOf((String)type))) {
                matcher = PATTERN_INDEX.matcher(src);
                String index = null;
                if (matcher.find()) {
                    index = matcher.group(1);
                }
                attachedPicture = ResourceUtil.getBlobHolderContent((NuxeoController)nuxeoController, (String)path, (String)index);
            }
            is = attachedPicture.getStream() != null ? attachedPicture.getStream() : new FileInputStream(attachedPicture.getFile());
            byteArray = IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(is);
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(is);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return byteArray;
    }
}

