/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.taglib.common;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.tag.INuxeoTagService;
import java.io.IOException;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.jsp.JspException;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.taglib.common.PortalSimpleTag;

public abstract class ToutaticeSimpleTag
extends PortalSimpleTag {
    private static final String NUXEO_CONTROLLER_REQUEST_ATTRIBUTE = NuxeoController.class.getName();
    private DocumentDTO document;
    private final INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    private final INuxeoTagService tagService = this.nuxeoService.getTagService();

    public void doTag() throws JspException, IOException {
        NuxeoController nuxeoController = this.getNuxeoController();
        this.doTag(nuxeoController, this.document);
    }

    protected NuxeoController getNuxeoController() throws JspException {
        PortletRequest request = this.getPortletRequest();
        NuxeoController nuxeoController = (NuxeoController)request.getAttribute(NUXEO_CONTROLLER_REQUEST_ATTRIBUTE);
        if (nuxeoController == null) {
            PortletResponse response = this.getPortletResponse();
            PortletContext portletContext = this.getPortletContext();
            nuxeoController = new NuxeoController(request, response, portletContext);
            request.setAttribute(NUXEO_CONTROLLER_REQUEST_ATTRIBUTE, (Object)nuxeoController);
        }
        if (this.document != null) {
            Document nuxeoDocument = this.document.getDocument();
            nuxeoController.setCurrentDoc(nuxeoDocument);
        } else {
            nuxeoController.setCurrentDoc(null);
        }
        return nuxeoController;
    }

    protected abstract void doTag(NuxeoController var1, DocumentDTO var2) throws JspException, IOException;

    public void setDocument(DocumentDTO document) {
        this.document = document;
    }

    public INuxeoService getNuxeoService() {
        return this.nuxeoService;
    }

    public INuxeoTagService getTagService() {
        return this.tagService;
    }
}

