/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.textpaster;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.image.color.ColorGenerator;
import com.octo.captcha.component.image.color.SingleColorGenerator;
import com.octo.captcha.component.image.textpaster.ChangeableAttributedString;
import com.octo.captcha.component.image.textpaster.RandomTextPaster;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;

public class BaffleRandomTextPaster
extends RandomTextPaster {
    private static double circleXRatio = 0.7;
    private static double circleYRatio = 0.5;
    private Integer numberOfHolesPerGlyph = new Integer(3);
    private ColorGenerator holesColorGenerator = null;

    public BaffleRandomTextPaster(Integer minAcceptedWordLength, Integer maxAcceptedWordLength, Color textColor, Integer numberOfHolesPerGlyph, Color holesColor) {
        super(minAcceptedWordLength, maxAcceptedWordLength, textColor);
        this.numberOfHolesPerGlyph = numberOfHolesPerGlyph != null ? numberOfHolesPerGlyph : this.numberOfHolesPerGlyph;
        this.holesColorGenerator = new SingleColorGenerator(holesColor != null ? holesColor : textColor);
    }

    public BaffleRandomTextPaster(Integer minAcceptedWordLength, Integer maxAcceptedWordLength, ColorGenerator colorGenerator, Integer numberOfHolesPerGlyph, Color holesColor) {
        super(minAcceptedWordLength, maxAcceptedWordLength, colorGenerator);
        this.numberOfHolesPerGlyph = numberOfHolesPerGlyph != null ? numberOfHolesPerGlyph : this.numberOfHolesPerGlyph;
        this.holesColorGenerator = new SingleColorGenerator(holesColor != null ? holesColor : colorGenerator.getNextColor());
    }

    public BaffleRandomTextPaster(Integer minAcceptedWordLength, Integer maxAcceptedWordLength, ColorGenerator colorGenerator, Boolean manageColorPerGlyph, Integer numberOfHolesPerGlyph, Color holesColor) {
        super(minAcceptedWordLength, maxAcceptedWordLength, colorGenerator, manageColorPerGlyph);
        this.numberOfHolesPerGlyph = numberOfHolesPerGlyph != null ? numberOfHolesPerGlyph : this.numberOfHolesPerGlyph;
        this.holesColorGenerator = new SingleColorGenerator(holesColor != null ? holesColor : colorGenerator.getNextColor());
    }

    public BaffleRandomTextPaster(Integer minAcceptedWordLength, Integer maxAcceptedWordLength, ColorGenerator colorGenerator, Boolean manageColorPerGlyph, Integer numberOfHolesPerGlyph, ColorGenerator holesColorGenerator) {
        super(minAcceptedWordLength, maxAcceptedWordLength, colorGenerator, manageColorPerGlyph);
        this.numberOfHolesPerGlyph = numberOfHolesPerGlyph != null ? numberOfHolesPerGlyph : this.numberOfHolesPerGlyph;
        this.holesColorGenerator = holesColorGenerator != null ? holesColorGenerator : colorGenerator;
    }

    public BufferedImage pasteText(BufferedImage background, AttributedString attributedWord) throws CaptchaException {
        BufferedImage out = this.copyBackground(background);
        Graphics2D g2 = this.pasteBackgroundAndSetTextColor(out, background);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ChangeableAttributedString newAttrString = new ChangeableAttributedString(g2, attributedWord, 20);
        newAttrString.useMinimumSpacing(20.0);
        newAttrString.moveToRandomSpot(background);
        if (this.isManageColorPerGlyph()) {
            newAttrString.drawString(g2, this.getColorGenerator());
        } else {
            newAttrString.drawString(g2);
        }
        g2.setColor(this.holesColorGenerator.getNextColor());
        for (int j = 0; j < attributedWord.getIterator().getEndIndex(); ++j) {
            Rectangle2D bounds = newAttrString.getBounds(j).getFrame();
            double circleMaxSize = bounds.getWidth() / 2.0;
            for (int i = 0; i < this.numberOfHolesPerGlyph; ++i) {
                double circleSize = circleMaxSize * (1.0 + this.myRandom.nextDouble()) / 2.0;
                double circlex = bounds.getMinX() + bounds.getWidth() * circleXRatio * this.myRandom.nextDouble();
                double circley = bounds.getMinY() - bounds.getHeight() * circleYRatio * this.myRandom.nextDouble();
                Ellipse2D.Double circle = new Ellipse2D.Double(circlex, circley, circleSize, circleSize);
                g2.fill(circle);
            }
        }
        g2.dispose();
        return out;
    }
}

