/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.bulkload;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.terracotta.modules.ehcache.store.bulkload.AggregateIterator;

public class UnmodifiableMultiSetWrapper<T>
extends AbstractSet<T> {
    private final List<Set<T>> delegates;

    public UnmodifiableMultiSetWrapper(Set<T> ... delegates) {
        this.delegates = Collections.unmodifiableList(Arrays.asList(delegates));
    }

    @Override
    public boolean contains(Object obj) {
        for (Set<T> c : this.delegates) {
            if (!c.contains(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        for (Set<T> c : this.delegates) {
            if (!c.containsAll(coll)) continue;
            return true;
        }
        for (Set<Object> o : coll) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (Set<T> c : this.delegates) {
            if (c.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList iterators = new ArrayList(this.delegates.size());
        for (Set<T> c : this.delegates) {
            iterators.add(c.iterator());
        }
        return new AggregateIterator(iterators);
    }

    @Override
    public int size() {
        long totalSize = 0L;
        for (Set<T> c : this.delegates) {
            totalSize += (long)c.size();
        }
        if (totalSize > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)totalSize;
    }
}

