/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget.google;

import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.text.FastURLEncoder;
import org.jboss.portal.common.util.UUIDGenerator;
import org.jboss.portal.widget.Widget;
import org.jboss.portal.widget.google.info.GGPreferenceInfo;
import org.jboss.portal.widget.google.info.GGPreferencesInfo;
import org.jboss.portal.widget.google.info.GGWidgetInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GGWidget
implements Widget {
    private static final UUIDGenerator generator = new UUIDGenerator();
    private final URL url;
    private final String id;
    private final GGWidgetInfo info;

    public GGWidget(URL url, GGWidgetInfo info) {
        this.id = url.toString();
        this.url = url;
        this.info = info;
    }

    public String getId() {
        return this.id;
    }

    public GGWidgetInfo getInfo() {
        return this.info;
    }

    public LocalizedString getTitle() {
        return this.getInfo().getTitle();
    }

    public LocalizedString getDirectoryTitle() {
        return this.getInfo().getDirectoryTitle();
    }

    public LocalizedString getDescription() {
        return this.getInfo().getDescription();
    }

    public String render(Map<String, String> parameters) {
        return this.render(parameters, null);
    }

    public String render(Map<String, String> parameters, Locale locale) {
        String id = generator.generateKey();
        StringBuffer tmp = new StringBuffer("http://gmodules.com/ig/ifr?url=").append(this.url);
        GGWidgetInfo info = this.getInfo();
        if (info != null) {
            tmp.append("&amp;synd=jboss");
            tmp.append("&amp;w=").append(info.getWidth());
            tmp.append("&amp;h=").append(info.getHeight());
            tmp.append("&amp;border=%23ffffff%7C3px%2C1px+none+%23999999");
            tmp.append("&amp;output=js");
            if (locale != null) {
                tmp.append("&lang=").append(locale.getLanguage());
                tmp.append("&country=").append(locale.getCountry());
            }
            GGPreferencesInfo prefsInfo = info.getPreferences();
            for (GGPreferenceInfo prefInfo : prefsInfo.getPreferences()) {
                String prefName = prefInfo.getName();
                String defaultValue = prefInfo.getDefaultValue() != null ? prefInfo.getDefaultValue() : "";
                String value = parameters.get(prefName);
                if (value == null) {
                    value = defaultValue;
                }
                if (value == null || defaultValue.equals(value)) continue;
                FastURLEncoder encoder = FastURLEncoder.getUTF8Instance();
                tmp.append("&amp;up_").append(encoder.encode(prefName)).append("=").append(encoder.encode(value));
            }
            String clipper = "(function(){\nvar a = document.getElementById('" + id + "');\n" + "var b = a.childNodes.item(2);\n" + "var c = b.childNodes.item(0);\n" + "var d = c.childNodes.item(0);\n" + "var e = c.childNodes.item(1);\n" + "var f = c.childNodes.item(3);\n" + "c.removeChild(d);\n" + "c.removeChild(e);\n" + "c.removeChild(f);\n" + "})();";
            return "<div id=\"" + id + "\">\n" + "<script src=\"" + tmp + "\"></script>\n" + "<script>" + clipper + "</script>\n" + "</div>\n";
        }
        return "Error";
    }
}

