/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.identity.CachedUserImpl;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.ldap.LDAPMembershipModule;
import org.jboss.portal.identity.ldap.LDAPRoleImpl;
import org.jboss.portal.identity.ldap.LDAPUserImpl;

public class LDAPStaticGroupMembershipModuleImpl
extends LDAPMembershipModule {
    private static final Logger log = Logger.getLogger(LDAPStaticGroupMembershipModuleImpl.class);

    public Set getRoles(User user) throws IdentityException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user instanceof CachedUserImpl) {
            try {
                user = this.getUserModule().findUserById(user.getId());
            }
            catch (NoSuchUserException e) {
                throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", e);
            }
        }
        LDAPUserImpl ldapUser = null;
        if (!(user instanceof LDAPUserImpl)) {
            throw new IllegalArgumentException("UserMembershipModuleImpl supports only LDAPUserImpl objects");
        }
        ldapUser = (LDAPUserImpl)user;
        HashSet<LDAPRoleImpl> roles = new HashSet<LDAPRoleImpl>();
        try {
            log.debug((Object)("getRoles(): user DN = " + ldapUser.getDn()));
            String memberName = "";
            memberName = this.isUidAttributeIsDN() ? ldapUser.getDn() : ldapUser.getUserName();
            String filter = this.getMemberAttributeID().concat("=").concat(memberName);
            log.debug((Object)("Search filter: " + filter));
            List sr = this.getRoleModule().searchRoles(filter, null);
            for (SearchResult res : sr) {
                DirContext ctx = (DirContext)res.getObject();
                roles.add(this.getRoleModule().createRoleInstance(res.getAttributes(), ctx.getNameInNamespace()));
                ctx.close();
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to resolve userRoles: " + ldapUser.getId().toString()), (Throwable)e);
        }
        return roles;
    }

    public Set getUsers(Role role) throws IdentityException {
        return this.getUsers(role, null);
    }

    public Set getUsers(Role role, String userNameFilter) throws IdentityException {
        if (role == null) {
            throw new IllegalArgumentException("Role cannot be null");
        }
        LDAPRoleImpl ldapRole = null;
        if (!(role instanceof LDAPRoleImpl)) {
            throw new IllegalArgumentException("UserMembershipModuleImpl supports only LDAPRoleImpl objects");
        }
        ldapRole = (LDAPRoleImpl)role;
        HashSet<User> users = new HashSet<User>();
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            log.debug((Object)("findUsers(): role = " + ldapRole.getDn()));
            if (ldapRole.getName() == null) {
                throw new IdentityException("Role name canot be null");
            }
            Attributes attrs = ldapContext.getAttributes(ldapRole.getDn(), new String[]{this.getMemberAttributeID()});
            if (attrs == null) {
                throw new IdentityException("Cannot find Role with DN: " + ldapRole.getDn());
            }
            Attribute memberAttr = attrs.get(this.getMemberAttributeID());
            if (memberAttr != null) {
                NamingEnumeration<?> values = memberAttr.getAll();
                while (values.hasMoreElements()) {
                    String value;
                    String name = value = values.nextElement().toString();
                    if (userNameFilter != null && userNameFilter.length() != 0 && !name.matches(".*" + userNameFilter + ".*")) continue;
                    try {
                        if (this.isUidAttributeIsDN()) {
                            users.add(this.getUserModule().findUserByDN(name));
                            continue;
                        }
                        users.add(this.getUserModule().findUserByUserName(name));
                    }
                    catch (IdentityException ie) {
                        log.error((Object)("Failed to find user: " + name + "/" + value), (Throwable)ie);
                    }
                }
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Resolving Role Users failed.", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return users;
    }

    public void assignUsers(Role role, Set users) throws IdentityException {
        if (role == null) {
            throw new IllegalArgumentException("Role cannot be null");
        }
        LDAPRoleImpl ldapRole = null;
        if (!(role instanceof LDAPRoleImpl)) {
            throw new IllegalArgumentException("UserMembershipModuleImpl supports only LDAPRoleImpl objects");
        }
        ldapRole = (LDAPRoleImpl)role;
        if (users.size() == 0 && this.isMembershipAttributeRequired()) {
            throw new IdentityException("Cannot assigne 0 users to a role using this membership strategy (because some LDAPs require the member field to be set). ");
        }
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            log.debug((Object)("findUsers(): role = " + ldapRole.getDn()));
            if (ldapRole.getName() == null) {
                throw new IdentityException("Role name canot be null");
            }
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute member = new BasicAttribute(this.getMemberAttributeID());
            Iterator iterator = users.iterator();
            while (iterator.hasNext()) {
                try {
                    User user = (User)iterator.next();
                    if (user instanceof CachedUserImpl) {
                        try {
                            user = this.getUserModule().findUserById(user.getId());
                        }
                        catch (NoSuchUserException e) {
                            throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", e);
                        }
                    }
                    LDAPUserImpl ldapUser = (LDAPUserImpl)user;
                    if (this.isUidAttributeIsDN()) {
                        member.add(ldapUser.getDn());
                        continue;
                    }
                    member.add(ldapUser.getUserName());
                }
                catch (ClassCastException e) {
                    throw new IdentityException("Can add only LDAPUserImpl objects", e);
                }
            }
            attrs.put(member);
            if (users.size() > 0) {
                ldapContext.modifyAttributes(ldapRole.getDn(), 2, (Attributes)attrs);
            } else {
                ldapContext.modifyAttributes(ldapRole.getDn(), 3, (Attributes)attrs);
            }
            this.fireMembershipChangedEvent(role, users);
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to change Role members", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignRoles(User user, Set roles) throws IdentityException {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (user instanceof CachedUserImpl) {
            try {
                user = this.getUserModule().findUserById(user.getId());
            }
            catch (NoSuchUserException e) {
                throw new IdentityException("Illegal state - cached user doesn't exist in identity store: ", e);
            }
        }
        LDAPUserImpl ldapUser = null;
        if (!(user instanceof LDAPUserImpl)) {
            throw new IllegalArgumentException("UserMembershipModuleImpl supports only LDAPUserImpl objects");
        }
        ldapUser = (LDAPUserImpl)user;
        LinkedList<String> roleDNsToAdd = new LinkedList<String>();
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            try {
                LDAPRoleImpl role = (LDAPRoleImpl)iterator.next();
                roleDNsToAdd.add(role.getDn());
            }
            catch (ClassCastException e) {
                throw new IdentityException("Only can add LDAPRoleImpl objects", e);
            }
        }
        String memberName = null;
        memberName = this.isUidAttributeIsDN() ? ldapUser.getDn() : ldapUser.getUserName();
        LdapContext ldapContext = this.getConnectionContext().createInitialContext();
        try {
            String filter = this.getMemberAttributeID().concat("=").concat(memberName);
            log.debug((Object)("Search filter: " + filter));
            List sr = this.getRoleModule().searchRoles(filter, null);
            for (SearchResult res : sr) {
                DirContext ctx = (DirContext)res.getObject();
                String roleDN = ctx.getNameInNamespace();
                ctx.close();
                if (roleDNsToAdd.contains(roleDN)) {
                    roleDNsToAdd.remove(roleDN);
                    continue;
                }
                Attributes attrs = ldapContext.getAttributes(roleDN, new String[]{this.getMemberAttributeID()});
                if (attrs == null) {
                    throw new IdentityException("Cannot find Role with DN: " + roleDN);
                }
                Attribute attr = attrs.get(this.getMemberAttributeID());
                if (attr.size() != 1 || !this.isMembershipAttributeRequired()) {
                    attr.remove(memberName);
                    BasicAttributes newAttrs = new BasicAttributes(true);
                    newAttrs.put(attr);
                    ldapContext.modifyAttributes(roleDN, 2, (Attributes)newAttrs);
                } else {
                    log.error((Object)"Couldn't remove user from role as it was the last member - possibly required field in ldap");
                }
                roleDNsToAdd.remove(roleDN);
            }
            for (String roleDN : roleDNsToAdd) {
                ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, new BasicAttribute(this.getMemberAttributeID(), memberName))};
                ldapContext.modifyAttributes(roleDN, mods);
            }
            this.fireMembershipChangedEvent(user, roles);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    public Set findRoleMembers(String roleName, int offset, int limit, String userNameFilter) throws IdentityException {
        Role role = this.getRoleModule().findRoleByName(roleName);
        if (role != null) {
            Set users = this.getUsers(role, userNameFilter);
            int size = users.size();
            if (offset == 0 && size <= limit) {
                return users;
            }
            Collections.sort(Tools.toList(users.iterator()), new LDAPUserImpl.LDAPUserComparator());
            if (offset + limit <= size) {
                return Tools.toSet(Tools.toList(users.iterator()).subList(offset, offset + limit).iterator());
            }
            if (offset >= size) {
                return new HashSet();
            }
            return Tools.toSet(Tools.toList(users.iterator()).subList(offset, size).iterator());
        }
        throw new IdentityException("Role not found with roleName: " + roleName);
    }
}

