/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.service;

import org.jboss.logging.Logger;
import org.jboss.portal.common.util.CopyOnWriteRegistry;
import org.jboss.portal.identity.event.IdentityEvent;
import org.jboss.portal.identity.event.IdentityEventBroadcaster;
import org.jboss.portal.identity.event.IdentityEventEmitter;
import org.jboss.portal.identity.event.IdentityEventListener;

public class IdentityEventManagerService
implements IdentityEventBroadcaster,
IdentityEventEmitter {
    private static final Logger log = Logger.getLogger(IdentityEventManagerService.class);
    private final CopyOnWriteRegistry listeners = new CopyOnWriteRegistry();

    public void addListener(IdentityEventListener listener) {
        this.listeners.register((Object)listener, (Object)listener);
    }

    public void removeListener(IdentityEventListener listener) {
        this.listeners.unregister((Object)listener);
    }

    public void fireEvent(IdentityEvent event) {
        for (IdentityEventListener listener : this.listeners.getRegistrations()) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                log.error((Object)("Listener " + listener + " threw an exception during event firing " + event), (Throwable)e);
            }
        }
    }
}

