/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.i18n;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.portal.common.i18n.AbstractLocaleFormat;
import org.jboss.portal.common.i18n.LocaleFactory;
import org.jboss.portal.common.i18n.LocaleManager;
import org.jboss.portal.common.text.CharWriter;
import org.jboss.portal.common.util.FormatConversionException;

class DefaultLocaleFormat
extends AbstractLocaleFormat {
    private static final Map CACHE = new HashMap();
    private LocaleFactory factory;

    public DefaultLocaleFormat(LocaleFactory factory) {
        this.factory = factory;
    }

    public DefaultLocaleFormat() {
        this(LocaleFactory.DEFAULT_FACTORY);
    }

    protected Locale internalGetLocale(String value) throws FormatConversionException {
        boolean emptyLanguage;
        Locale locale = (Locale)CACHE.get(value);
        if (locale != null) {
            return locale;
        }
        int p1 = value.lastIndexOf(95);
        if (p1 < 0) {
            return this.factory.createLocale(value);
        }
        String a = p1 == value.length() - 1 ? "" : value.substring(p1 + 1, value.length());
        int p2 = value.lastIndexOf(95, p1 - 1);
        if (p2 < 0) {
            if (a.length() == 0) {
                throw new FormatConversionException();
            }
            return this.factory.createLocale(value.substring(0, p1), a);
        }
        boolean bl = emptyLanguage = p2 == p1 - 1;
        if (p2 == 0 && emptyLanguage) {
            throw new FormatConversionException();
        }
        String b = emptyLanguage ? "" : value.substring(p2 + 1, p1);
        return this.factory.createLocale(value.substring(0, p2), b, a);
    }

    protected void internalWrite(Locale locale, CharWriter writer) throws IOException {
        writer.append(locale.toString());
    }

    static {
        for (Locale locale : LocaleManager.getLocales()) {
            CACHE.put(locale.toString(), locale);
        }
    }
}

