/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.i18n;

import java.util.Locale;

public class I18NTools {
    private static final String RFC3066_SEPARATOR = "-";

    public static String getRFC3066LanguageTagFor(Locale locale) {
        String country = locale.getCountry();
        return locale.getLanguage() + (country.length() == 2 ? RFC3066_SEPARATOR + country : country);
    }

    public static String computeTrailingName(Locale locale) throws IllegalArgumentException {
        if (locale == null) {
            throw new IllegalArgumentException("locale parameter is null");
        }
        StringBuffer tmp = new StringBuffer();
        if (locale.getLanguage() != null && locale.getLanguage().length() > 0) {
            tmp.append('_').append(locale.getLanguage());
            if (locale.getCountry() != null && locale.getCountry().length() > 0) {
                tmp.append('_').append(locale.getCountry());
                if (locale.getVariant() != null && locale.getVariant().length() > 0) {
                    tmp.append('_').append(locale.getVariant());
                }
            }
        }
        return tmp.toString();
    }
}

