/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.value;

import org.jboss.portal.common.util.FormatConversionException;
import org.jboss.portal.common.util.NullConversionException;
import org.jboss.portal.common.value.Converter;

@Deprecated
public class Helper {
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Converter FLOAT_CONVERTER = new Converter(){

        public boolean accept(Class clazz) {
            return Float.class.equals((Object)clazz);
        }

        public Object toObject(String value) throws NullConversionException, FormatConversionException {
            if (value == null) {
                return null;
            }
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new FormatConversionException();
            }
        }

        public String toString(Object value) throws NullConversionException, FormatConversionException {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Float)) {
                throw new FormatConversionException();
            }
            return value.toString();
        }
    };
    public static final Converter INTEGER_CONVERTER = new Converter(){

        public boolean accept(Class clazz) {
            return Integer.class.equals((Object)clazz);
        }

        public Object toObject(String value) throws NullConversionException, FormatConversionException {
            if (value == null) {
                return null;
            }
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new FormatConversionException();
            }
        }

        public String toString(Object value) throws NullConversionException, FormatConversionException {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Integer)) {
                throw new FormatConversionException();
            }
            return value.toString();
        }
    };
    public static final Converter BOOLEAN_CONVERTER = new Converter(){

        public boolean accept(Class clazz) {
            return Boolean.class.equals((Object)clazz);
        }

        public Object toObject(String value) throws NullConversionException, FormatConversionException {
            if (value == null) {
                return null;
            }
            return Helper.toBoolean(value);
        }

        public String toString(Object value) throws NullConversionException, FormatConversionException {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Boolean)) {
                throw new FormatConversionException();
            }
            return value.toString();
        }
    };

    public static int toInt(String value) throws NullConversionException, FormatConversionException {
        try {
            if (value == null) {
                throw new NullConversionException();
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new FormatConversionException();
        }
    }

    public static boolean toBoolean(String value) throws NullConversionException, FormatConversionException {
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        if (value == null) {
            throw new NullConversionException();
        }
        throw new FormatConversionException();
    }

    public static String toString(int value) {
        return Integer.toString(value);
    }

    public static String toString(boolean value) {
        return Boolean.toString(value);
    }

    public static String toString(Object value, Converter converter) throws NullConversionException, FormatConversionException, IllegalArgumentException {
        if (converter == null) {
            throw new IllegalArgumentException();
        }
        return converter.toString(value);
    }

    public static String[] toStringArray(int[] values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        String[] strings = new String[values.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = Integer.toString(values[i]);
        }
        return strings;
    }

    public static String[] toStringArray(boolean[] values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        String[] strings = new String[values.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = Boolean.toString(values[i]);
        }
        return strings;
    }

    public static String[] toStringArray(Object[] values, Converter converter) throws NullConversionException, FormatConversionException, IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if (converter == null) {
            throw new IllegalArgumentException();
        }
        String[] strings = new String[values.length];
        for (int i = 0; i < strings.length; ++i) {
            Object value = values[i];
            if (value == null) continue;
            strings[i] = converter.toString(values[i]);
        }
        return strings;
    }
}

