/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.jsr168.api;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowStateException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.NotYetImplemented;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.impl.info.ContainerEventInfo;
import org.jboss.portal.portlet.impl.info.ContainerPortletApplicationInfo;
import org.jboss.portal.portlet.impl.info.ContainerTypeInfo;
import org.jboss.portal.portlet.impl.jsr168.PortletApplicationImpl;
import org.jboss.portal.portlet.impl.jsr168.PortletParameterMap;
import org.jboss.portal.portlet.impl.jsr168.api.ActionResponseImpl;
import org.jboss.portal.portlet.impl.jsr168.api.PortletRequestImpl;
import org.jboss.portal.portlet.impl.jsr168.api.PortletResponseImpl;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.HTTPRedirectionResponse;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.invocation.response.UpdateNavigationalStateResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StateAwareResponseImpl
extends PortletResponseImpl
implements StateAwareResponse {
    private static final Logger log = Logger.getLogger(ActionResponseImpl.class);
    protected WantUpdate wantUpdate;
    protected WantRedirect wantRedirect;
    private List<UpdateNavigationalStateResponse.Event> events;
    private static final Set<? extends Class<? extends Serializable>> acceptedFinalClasses = Tools.toSet((Object[])new Class[]{Boolean.class, Integer.class, Byte.class, Long.class, Float.class, Double.class, String.class, URI.class, UUID.class});

    public StateAwareResponseImpl(PortletInvocation invocation, PortletRequestImpl preq) {
        super(invocation, preq);
    }

    @Override
    public PortletInvocationResponse getResponse() {
        Decision decision = this.wantRedirect;
        if (this.wantRedirect == null) {
            decision = this.wantUpdate;
        }
        if (decision == null) {
            decision = new WantUpdate();
        }
        return decision.getResponse();
    }

    protected WantUpdate requireUpdate(String errorMsg) {
        if (this.wantRedirect != null) {
            throw new IllegalStateException(errorMsg);
        }
        if (this.wantUpdate == null) {
            this.wantUpdate = new WantUpdate();
        }
        return this.wantUpdate;
    }

    protected void checkRedirect(String errorMsg) {
        if (this.wantUpdate != null) {
            throw new IllegalStateException(errorMsg);
        }
    }

    protected WantRedirect requireRedirect() {
        if (this.wantUpdate != null) {
            throw new IllegalStateException();
        }
        if (this.wantRedirect == null) {
            this.wantRedirect = new WantRedirect();
        }
        return this.wantRedirect;
    }

    protected WantUpdate wantUpdate() {
        if (this.wantUpdate == null) {
            this.wantUpdate = new WantUpdate();
        }
        return this.wantUpdate;
    }

    public void setWindowState(javax.portlet.WindowState windowState) throws WindowStateException {
        WantUpdate update = this.requireUpdate("Window state cannot be set after redirect");
        if (!this.preq.isWindowStateAllowed(windowState)) {
            throw new WindowStateException("Not supported", windowState);
        }
        update.windowState = WindowState.create((String)windowState.toString());
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        WantUpdate update = this.requireUpdate("Portlet mode cannot be set after redirect");
        if (portletMode == null) {
            log.warn((Object)"Set null portlet mode");
        } else {
            if (!this.preq.isPortletModeAllowed(portletMode)) {
                throw new PortletModeException("Not supported", portletMode);
            }
            update.mode = Mode.create((String)portletMode.toString());
        }
    }

    public void setRenderParameters(Map<String, String[]> map) {
        WantUpdate update = this.requireUpdate("setRenderParameters cannot be called after redirect");
        update.navigationalState.setMap(map);
    }

    public void setRenderParameter(String name, String value) {
        WantUpdate update = this.requireUpdate("setRenderParameter cannot be called after redirect");
        update.navigationalState.setParameterValue(name, value);
    }

    public void setRenderParameter(String name, String[] values) {
        WantUpdate update = this.requireUpdate("setRenderParameter cannot be called after redirect");
        update.navigationalState.setParameterValues(name, values);
    }

    public Map<String, String[]> getRenderParameterMap() {
        WantUpdate update = this.wantUpdate();
        return update.navigationalState.getMap();
    }

    public void removePublicRenderParameter(String name) {
        WantUpdate update = this.wantUpdate();
        update.navigationalState.removePublicParameterValue(name);
    }

    private boolean requiresJAXBAnnotation(Class<? extends Serializable> clazz) {
        if (acceptedFinalClasses.contains(clazz)) {
            return false;
        }
        if (clazz.getName().startsWith("java")) {
            if (BigInteger.class.isAssignableFrom(clazz)) {
                return false;
            }
            if (BigDecimal.class.isAssignableFrom(clazz)) {
                return false;
            }
            if (Calendar.class.isAssignableFrom(clazz)) {
                return false;
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return false;
            }
            if (QName.class.isAssignableFrom(clazz)) {
                return false;
            }
        }
        return true;
    }

    public void setEvent(QName name, Serializable value) {
        if (name == null) {
            throw new IllegalArgumentException("The portlet must specify a name when producing an event");
        }
        if (value != null) {
            Class expectedType;
            ContainerTypeInfo typeInfo;
            boolean b;
            Class<?> valueType = value.getClass();
            if (this.requiresJAXBAnnotation(valueType) && !(b = valueType.isAnnotationPresent(XmlRootElement.class))) {
                throw new IllegalArgumentException("The provided event value type " + value.getClass().getName() + " does not have a valid jaxb annotation");
            }
            ContainerEventInfo eventInfo = this.preq.container.getInfo().getEventing().getProducedEvents().get(name);
            if (eventInfo != null && (typeInfo = eventInfo.getType()) != null && !(expectedType = typeInfo.getType()).isInstance(value)) {
                throw new IllegalArgumentException("The provided event value type " + valueType.getName() + " does not match the declared event type " + expectedType.getName());
            }
        }
        this.queueEvent(name, value);
    }

    public void setEvent(String localName, Serializable value) {
        if (localName == null) {
            throw new IllegalArgumentException("The portlet must specify a local name when producing an event");
        }
        ContainerPortletApplicationInfo info = ((PortletApplicationImpl)this.preq.container.getPortletApplication()).getInfo();
        QName name = new QName(info.getDefaultNamespace(), localName);
        this.setEvent(name, value);
    }

    public PortletMode getPortletMode() {
        throw new NotYetImplemented();
    }

    public javax.portlet.WindowState getWindowState() {
        throw new NotYetImplemented();
    }

    protected final void queueEvent(QName name, Serializable value) {
        if (this.events == null) {
            this.events = new LinkedList<UpdateNavigationalStateResponse.Event>();
        }
        this.events.add(new UpdateNavigationalStateResponse.Event(name, value));
    }

    protected class WantRedirect
    extends Decision {
        protected String location;

        protected WantRedirect() {
        }

        protected PortletInvocationResponse getResponse() {
            return new HTTPRedirectionResponse(this.location);
        }
    }

    protected class WantUpdate
    extends Decision {
        protected PortletParameterMap navigationalState;
        protected WindowState windowState;
        protected Mode mode;

        protected WantUpdate() {
            this.navigationalState = new PortletParameterMap(StateAwareResponseImpl.this.preq.navigationInfo);
            this.windowState = new WindowState(StateAwareResponseImpl.this.preq.getWindowState().toString());
            this.mode = new Mode(StateAwareResponseImpl.this.preq.getPortletMode().toString());
        }

        protected PortletInvocationResponse getResponse() {
            UpdateNavigationalStateResponse response = new UpdateNavigationalStateResponse();
            response.setProperties(StateAwareResponseImpl.this.getProperties(false));
            response.setAttributes(StateAwareResponseImpl.this.preq.attributes.getAttributeMap());
            response.setMode(this.mode);
            response.setWindowState(this.windowState);
            response.setPublicNavigationalStateUpdates(this.navigationalState.getPublicMapSnapshot());
            response.setNavigationalState(ParametersStateString.create(this.navigationalState.getPrivateMapSnapshot()));
            if (StateAwareResponseImpl.this.events != null) {
                for (UpdateNavigationalStateResponse.Event event : StateAwareResponseImpl.this.events) {
                    response.queueEvent(event);
                }
            }
            return response;
        }
    }

    private abstract class Decision {
        private Decision() {
        }

        protected abstract PortletInvocationResponse getResponse();
    }
}

