/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.coordination;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.jboss.portal.core.admin.ui.PortalObjectManagerBean;
import org.jboss.portal.core.admin.ui.coordination.AliasBindingManagerBean;
import org.jboss.portal.core.admin.ui.coordination.EventWiringManagerBean;
import org.jboss.portal.core.admin.ui.coordination.ParameterBindingManagerBean;
import org.jboss.portal.core.controller.coordination.CoordinationConfigurator;
import org.jboss.portal.core.controller.coordination.IllegalCoordinationException;
import org.jboss.portal.core.impl.model.content.portlet.PortletContent;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PageContainer;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.faces.gui.ManagedBean;
import org.jboss.portal.portlet.info.PortletInfo;

public class CoordinationManagerBean
extends ManagedBean {
    private PortalObjectManagerBean pomb;
    private Map<String, CoordinationBean> managers = new HashMap<String, CoordinationBean>();
    private static final String RESOURCE_NAME = "Resource";
    private static final String SELECTED_NAME = "name";
    private static final String SELECTED_TYPE = "type";
    private String selectedName;
    private CoordinationType selectedType;
    private String newName;
    static final String EDIT_COORDINATION = "editCoordination";
    private static final String RENAME_COORDINATION = "renameCoordination";

    public Page getSelectedPage() {
        PortalObject portalObject = this.pomb.getSelectedObject();
        if (portalObject.getType() != 2) {
            throw new IllegalArgumentException("Coordination can only be dealt with at the page level!");
        }
        return (Page)portalObject;
    }

    public PortalObjectManagerBean getPomb() {
        return this.pomb;
    }

    public void setPomb(PortalObjectManagerBean pomb) {
        this.pomb = pomb;
    }

    public InstanceContainer getInstanceContainer() {
        return this.pomb.getInstanceContainer();
    }

    public CoordinationConfigurator getCoordinationService() {
        return this.pomb.getCoordinationService();
    }

    public PortalObjectContainer getPortalObjectContainer() {
        return this.pomb.getPortalObjectContainer();
    }

    public EventWiringManagerBean getEventManager() {
        return (EventWiringManagerBean)this.managers.get(CoordinationType.wiring.name());
    }

    public void setEventManager(EventWiringManagerBean eventManager) {
        eventManager.setManagerBean(this);
        this.managers.put(CoordinationType.wiring.name(), eventManager);
    }

    public ParameterBindingManagerBean getParameterManager() {
        return (ParameterBindingManagerBean)this.managers.get(CoordinationType.parameter.name());
    }

    public void setParameterManager(ParameterBindingManagerBean parameterManager) {
        parameterManager.setManagerBean(this);
        this.managers.put(CoordinationType.parameter.name(), parameterManager);
    }

    public AliasBindingManagerBean getAliasManager() {
        return (AliasBindingManagerBean)this.managers.get(CoordinationType.alias.name());
    }

    public void setAliasManager(AliasBindingManagerBean aliasManager) {
        aliasManager.setManagerBean(this);
        this.managers.put(CoordinationType.alias.name(), aliasManager);
    }

    public boolean isExplicitEventsUsed() {
        boolean enabled = false;
        Page page = this.getSelectedPage();
        Boolean implicitEvents = this.getCoordinationService().isEventWiringImplicitModeEnabled((PageContainer)page);
        if (implicitEvents != null) {
            enabled = implicitEvents == false;
        }
        return enabled;
    }

    public void setExplicitEventsUsed(boolean usingExplicitEvents) {
        try {
            this.getCoordinationService().setEventWiringImplicitMode((PageContainer)this.getSelectedPage(), !usingExplicitEvents);
            this.refresh();
        }
        catch (IllegalCoordinationException e) {
            e.printStackTrace();
        }
    }

    public boolean isExplicitParametersUsed() {
        boolean enabled = false;
        Page page = this.getSelectedPage();
        Boolean implicitParameter = this.getCoordinationService().isParameterBindingImplicitModeEnabled((PageContainer)page);
        if (implicitParameter != null) {
            enabled = implicitParameter == false;
        }
        return enabled;
    }

    public void setExplicitParametersUsed(boolean usingExplicitParameters) {
        try {
            this.getCoordinationService().setParameterBindingImplicitMode((PageContainer)this.getSelectedPage(), !usingExplicitParameters);
            this.refresh();
        }
        catch (IllegalCoordinationException e) {
            e.printStackTrace();
        }
    }

    public String editCoordination() {
        try {
            AliasBindingManagerBean aliasManager = new AliasBindingManagerBean(this);
            aliasManager.setBeanContext(this.beanContext);
            EventWiringManagerBean eventManager = new EventWiringManagerBean(this);
            eventManager.setBeanContext(this.beanContext);
            ParameterBindingManagerBean parameterManager = new ParameterBindingManagerBean(this);
            parameterManager.setBeanContext(this.beanContext);
            this.managers.put(CoordinationType.alias.name(), (CoordinationBean)((Object)this.beanContext.replaceInSession("aliasManager", (Object)aliasManager)));
            this.managers.put(CoordinationType.wiring.name(), (CoordinationBean)((Object)this.beanContext.replaceInSession("eventManager", (Object)eventManager)));
            this.managers.put(CoordinationType.parameter.name(), (CoordinationBean)((Object)this.beanContext.replaceInSession("parameterManager", (Object)parameterManager)));
            Page selectedPage = this.getSelectedPage();
            aliasManager.loadInfoFrom(selectedPage);
            boolean explicitEventsUsed = eventManager.loadInfoFrom(selectedPage);
            boolean explicitParametersUsed = parameterManager.loadInfoFrom(selectedPage);
            Collection children = selectedPage.getChildren(8);
            if (!children.isEmpty()) {
                aliasManager.initKnowing(children);
                if (explicitParametersUsed) {
                    parameterManager.initKnowing(children);
                }
                for (PortalObject po : children) {
                    Window window = (Window)po;
                    if (!ContentType.PORTLET.equals((Object)window.getContentType())) continue;
                    PortletContent pc = (PortletContent)window.getContent();
                    InstanceDefinition instance = this.pomb.getInstanceContainer().getDefinition(pc.getInstanceRef());
                    if (instance == null) continue;
                    PortletInfo info = instance.getPortlet().getInfo();
                    aliasManager.extractInfoFrom(window, info);
                    if (explicitEventsUsed) {
                        eventManager.extractInfoFrom(window, info);
                    }
                    if (!explicitParametersUsed) continue;
                    parameterManager.extractInfoFrom(window, info);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return EDIT_COORDINATION;
    }

    PortalObjectId parsePortalObjectId(String id) {
        return PortalObjectId.parse((String)id, (PortalObjectPath.Format)PortalObjectPath.LEGACY_BASE64_FORMAT);
    }

    public void select(ActionEvent event) {
        this.selectedName = this.beanContext.getParameter(SELECTED_NAME);
        this.selectedType = CoordinationType.valueOf(this.beanContext.getParameter(SELECTED_TYPE));
        this.selectedType.setBean(this.managers.get(this.selectedType.name()));
    }

    public String getSelectedName() {
        return this.selectedName;
    }

    public String getSelectedType() {
        Locale locale = FacesContext.getCurrentInstance().getExternalContext().getRequestLocale();
        ResourceBundle rb = ResourceBundle.getBundle(RESOURCE_NAME, locale);
        return rb.getString(this.selectedType.localizationKey());
    }

    public String deleteSelected(ActionEvent actionEvent) {
        if (this.selectedType != null) {
            try {
                this.selectedType.getBean().delete(this.selectedName);
                this.refresh();
            }
            catch (IllegalCoordinationException e) {
                this.beanContext.createErrorMessageFrom((Exception)((Object)e));
            }
        }
        this.selectedType = null;
        this.selectedName = null;
        return EDIT_COORDINATION;
    }

    public void refresh() {
        this.editCoordination();
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getNewName() {
        return this.newName;
    }

    public String renameSelected() throws IllegalCoordinationException {
        if (this.selectedType != null) {
            CoordinationBean coordinationBean = this.selectedType.getBean();
            if (RENAME_COORDINATION.equals(coordinationBean.rename(this.selectedName, this.newName))) {
                return RENAME_COORDINATION;
            }
            this.refresh();
        }
        this.selectedType = null;
        this.selectedName = null;
        this.newName = null;
        return EDIT_COORDINATION;
    }

    protected String getObjectTypeName() {
        return this.selectedType.getBean().getObjectTypeName();
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.selectedType.getBean().isAlreadyExisting(objectName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CoordinationBean
    extends ManagedBean {
        protected CoordinationManagerBean managerBean;

        protected CoordinationBean() {
        }

        protected CoordinationBean(CoordinationManagerBean managerBean) {
            this.managerBean = managerBean;
        }

        public CoordinationManagerBean getManagerBean() {
            return this.managerBean;
        }

        public void setManagerBean(CoordinationManagerBean managerBean) {
            this.managerBean = managerBean;
        }

        public abstract boolean loadInfoFrom(Page var1);

        public abstract String delete(String var1) throws IllegalCoordinationException;

        public String rename(String oldName, String newName) {
            if (this.isOldAndNewDifferent(oldName, newName)) {
                if (this.checkNameValidity(newName, "renameForm:newName") != null) {
                    try {
                        this.internalRename(oldName, newName);
                    }
                    catch (IllegalCoordinationException e) {
                        this.beanContext.createErrorMessageFrom((Exception)((Object)e));
                    }
                } else {
                    return CoordinationManagerBean.RENAME_COORDINATION;
                }
            }
            return this.resetSelection();
        }

        protected abstract void internalRename(String var1, String var2) throws IllegalCoordinationException;

        public abstract void extractInfoFrom(Window var1, PortletInfo var2);

        public String create() {
            String nameForMessages = this.getObjectNameForMessages();
            String target = "create-" + nameForMessages + "-form:" + this.getAdditionalFormId() + nameForMessages + "Name";
            if (this.checkNameValidity(this.getBeanName(), target) != null) {
                try {
                    this.internalCreate();
                }
                catch (IllegalCoordinationException e) {
                    this.beanContext.createErrorMessageFrom((Exception)((Object)e));
                }
            } else {
                return null;
            }
            return this.resetSelection();
        }

        protected abstract void internalCreate() throws IllegalCoordinationException;

        public String resetSelection() {
            this.managerBean.refresh();
            return CoordinationManagerBean.EDIT_COORDINATION;
        }

        public String cancel() {
            return this.resetSelection();
        }

        public abstract void initKnowing(Collection<PortalObject> var1);

        public abstract String getObjectTypeName();

        protected abstract String getObjectNameForMessages();

        protected abstract String getBeanName();

        protected String getAdditionalFormId() {
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CoordinationType {
        wiring{

            String localizationKey() {
                return "COORDINATION_WIRING";
            }
        }
        ,
        parameter{

            String localizationKey() {
                return "COORDINATION_PARAMETER";
            }
        }
        ,
        alias{

            String localizationKey() {
                return "COORDINATION_ALIAS";
            }
        };

        private CoordinationBean bean;

        CoordinationBean getBean() {
            return this.bean;
        }

        void setBean(CoordinationBean bean) {
            this.bean = bean;
        }

        abstract String localizationKey();
    }
}

