/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import com.github.inspektr.audit.AuditActionContext;
import com.github.inspektr.audit.AuditTrailManager;
import com.github.inspektr.common.web.ClientInfo;
import com.github.inspektr.common.web.ClientInfoHolder;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;
import org.springframework.jdbc.core.JdbcTemplate;

public class InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter
extends AbstractThrottledSubmissionHandlerInterceptorAdapter {
    private static final String DEFAULT_APPLICATION_CODE = "CAS";
    private static final String INSPEKTR_ACTION = "THROTTLED_LOGIN_ATTEMPT";
    private final AuditTrailManager auditTrailManager;
    private final JdbcTemplate jdbcTemplate;
    private String applicationCode = "CAS";

    public InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter(AuditTrailManager auditTrailManager, DataSource dataSource) {
        this.auditTrailManager = auditTrailManager;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    protected final int findCount(HttpServletRequest request, String usernameParameter, int failureRangeInSeconds) {
        String userToUse = this.constructUsername(request, usernameParameter);
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -1 * failureRangeInSeconds);
        Date oldestDate = calendar.getTime();
        return this.jdbcTemplate.queryForInt("Select count(*) from COM_AUDIT_TRAIL where AUD_CLIENT_IP = ? and AUD_USER = ? AND AUD_ACTION = ? AND APPLIC_CD = ? AND AUD_DATE >= ?", new Object[]{request.getRemoteAddr(), userToUse, INSPEKTR_ACTION, this.applicationCode, oldestDate}, new int[]{12, 12, 12, 12, 93});
    }

    protected final void updateCount(HttpServletRequest request, String usernameParameter) {
        String userToUse = this.constructUsername(request, usernameParameter);
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        AuditActionContext context = new AuditActionContext(userToUse, userToUse, INSPEKTR_ACTION, this.applicationCode, new Date(), clientInfo.getClientIpAddress(), clientInfo.getServerIpAddress());
        this.auditTrailManager.record(context);
    }

    public final void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    protected String constructUsername(HttpServletRequest request, String usernameParameter) {
        String username = request.getParameter(usernameParameter);
        return "[username: " + (username != null ? username : "") + "]";
    }
}

