/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.deployment;

import java.io.File;
import java.io.FileOutputStream;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.mx.loading.UnifiedClassLoader;

public class JBossClassPool32
extends AOPClassPool {
    protected File tempdir = null;
    protected final Object tmplock = new Object();

    protected JBossClassPool32(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, File tmp) {
        super(cl, src, repository);
        this.tempdir = tmp;
    }

    protected JBossClassPool32(ClassPool src, ScopedClassPoolRepository repository) {
        super(src, repository);
    }

    public boolean isUnloadedClassLoader() {
        if (this.getClassLoader() instanceof UnifiedClassLoader) {
            UnifiedClassLoader rcl = (UnifiedClassLoader)this.getClassLoader();
            return rcl.getLoaderRepository() == null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class toClass(CtClass cc, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        this.lockInCache(cc);
        if (this.getClassLoader() == null || this.tempdir == null) {
            return super.toClass(cc, loader, domain);
        }
        Class<?> dynClass = null;
        try {
            File classFile = null;
            String classFileName = cc.getName().replace('.', '/') + ".class";
            Object object = this.tmplock;
            synchronized (object) {
                classFile = new File(this.tempdir, classFileName);
                File pkgDirs = classFile.getParentFile();
                pkgDirs.mkdirs();
                FileOutputStream stream = new FileOutputStream(classFile);
                stream.write(cc.toBytecode());
                stream.flush();
                stream.close();
                classFile.deleteOnExit();
            }
            UnifiedClassLoader rcl = (UnifiedClassLoader)this.getClassLoader();
            rcl.clearBlackLists();
            dynClass = this.getClassLoader().loadClass(cc.getName());
        }
        catch (Exception ex) {
            ClassFormatError cfe = new ClassFormatError("Failed to load dyn class: " + cc.getName());
            cfe.initCause(ex);
            throw cfe;
        }
        return dynClass;
    }
}

