/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.aspects.server;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.jboss.portal.common.i18n.LocaleFormat;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.common.util.ConversionException;
import org.jboss.portal.server.ServerInterceptor;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.server.ServerRequest;

public class LocaleInterceptor
extends ServerInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(ServerInvocation invocation) throws Exception, InvocationException {
        ArrayList<Locale> locales = new ArrayList<Locale>(4);
        Map profile = (Map)invocation.getAttribute(ServerInvocation.PRINCIPAL_SCOPE, (Object)"profile");
        if (profile != null) {
            Locale locale = null;
            Object lc = profile.get("portal.user.locale");
            if (lc instanceof Locale) {
                locale = (Locale)lc;
            } else if (lc != null) {
                try {
                    locale = LocaleFormat.DEFAULT.getLocale(lc.toString());
                }
                catch (ConversionException e) {
                    // empty catch block
                }
            }
            if (locale != null) {
                locales.add(locale);
            }
        }
        ServerRequest req = invocation.getRequest();
        locales.add(invocation.getServerContext().getClientRequest().getLocale());
        try {
            Locale[] tmp = locales.toArray(new Locale[locales.size()]);
            req.setLocales(tmp);
            invocation.invokeNext();
        }
        finally {
            req.setLocales(null);
        }
    }
}

