/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.portlet.info;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.jboss.portal.common.transaction.Transactions;
import org.jboss.portal.core.impl.portlet.info.AjaxInfoImpl;
import org.jboss.portal.core.impl.portlet.info.CoreInfoBuilderContext;
import org.jboss.portal.core.impl.portlet.info.MarkupHeaderInfoImpl;
import org.jboss.portal.core.impl.portlet.info.PortletInfoInfoImpl;
import org.jboss.portal.core.impl.portlet.info.TransactionInfoImpl;
import org.jboss.portal.core.impl.portlet.info.WSRPInfoImpl;
import org.jboss.portal.core.metadata.portlet.AjaxMetaData;
import org.jboss.portal.core.metadata.portlet.HeaderContentMetaData;
import org.jboss.portal.core.metadata.portlet.PortletInfoMetaData;
import org.jboss.portal.core.portlet.info.AjaxInfo;
import org.jboss.portal.core.portlet.info.MarkupHeaderInfo;
import org.jboss.portal.core.portlet.info.PortletInfoInfo;
import org.jboss.portal.core.portlet.info.TransactionInfo;
import org.jboss.portal.core.portlet.info.WSRPInfo;
import org.jboss.portal.portlet.container.PortletApplicationContext;
import org.jboss.portal.portlet.deployment.jboss.InfoBuilder;
import org.jboss.portal.portlet.deployment.jboss.PortletApplicationContextImpl;
import org.jboss.portal.portlet.deployment.jboss.info.SessionInfo;
import org.jboss.portal.portlet.deployment.jboss.info.impl.SessionInfoImpl;
import org.jboss.portal.portlet.deployment.jboss.metadata.JBossApplicationMetaData;
import org.jboss.portal.portlet.deployment.jboss.metadata.JBossPortletMetaData;
import org.jboss.portal.portlet.impl.info.ContainerInfoBuilder;
import org.jboss.portal.portlet.impl.info.ContainerInfoBuilderContext;
import org.jboss.portal.portlet.impl.info.ContainerPortletApplicationInfo;
import org.jboss.portal.portlet.impl.info.ContainerPortletInfo;
import org.jboss.portal.portlet.impl.jsr168.ContainerInfoBuilderContextImpl;
import org.jboss.portal.portlet.impl.metadata.PortletApplication10MetaData;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.web.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreInfoBuilder
implements InfoBuilder {
    private static final Logger log = Logger.getLogger(CoreInfoBuilder.class);
    private JBossApplicationMetaData jbossApplicationMetaData;
    private PortletApplication10MetaData portletApplicationMD;
    private CoreInfoBuilderContext builderContext;
    private LinkedHashMap<String, PortletInfo> portlets;
    private ContainerPortletApplicationInfo application;

    public CoreInfoBuilder(JBossApplicationMetaData jbossApplicationMetaData, PortletApplication10MetaData portletApplicationMD, CoreInfoBuilderContext builderContext) {
        this.portletApplicationMD = portletApplicationMD;
        this.jbossApplicationMetaData = jbossApplicationMetaData;
        this.builderContext = builderContext;
        this.portlets = new LinkedHashMap();
    }

    public Collection<PortletInfo> getPortlets() {
        return this.portlets.values();
    }

    public ContainerPortletApplicationInfo getApplication() {
        return this.application;
    }

    public void build() {
        String contextPath = this.builderContext.getWebApp().getContextPath();
        String id = this.jbossApplicationMetaData.getId();
        log.debug((Object)("Going to build portlet application metadata for application with context path '" + contextPath + "' with id '" + id + "'"));
        ContainerInfoBuilderContextImpl containerBuilderContext = new ContainerInfoBuilderContextImpl(this.portletApplicationMD, (WebApp)this.builderContext.getWebApp());
        ContainerInfoBuilder builder = new ContainerInfoBuilder(id, this.portletApplicationMD, (ContainerInfoBuilderContext)containerBuilderContext);
        builder.build();
        this.application = builder.getApplication();
        for (ContainerPortletInfo containerInfo : builder.getPortlets()) {
            String name = containerInfo.getName();
            JBossPortletMetaData jbPortletMD = (JBossPortletMetaData)this.jbossApplicationMetaData.getPortlets().get(name);
            if (jbPortletMD instanceof org.jboss.portal.core.metadata.portlet.JBossPortletMetaData) {
                Boolean remotable;
                Boolean distributed;
                Transactions.Type txType;
                PortletInfoMetaData portletInfoMD;
                HeaderContentMetaData headerContentMD;
                org.jboss.portal.core.metadata.portlet.JBossPortletMetaData jbossPortletMD = (org.jboss.portal.core.metadata.portlet.JBossPortletMetaData)jbPortletMD;
                AjaxMetaData ajaxMD = jbossPortletMD.getAjax();
                if (ajaxMD != null) {
                    containerInfo.setAttachment(AjaxInfo.class, (Object)new AjaxInfoImpl(ajaxMD));
                }
                if ((headerContentMD = jbossPortletMD.getHeaderContent()) != null) {
                    containerInfo.setAttachment(MarkupHeaderInfo.class, (Object)new MarkupHeaderInfoImpl(headerContentMD));
                }
                if ((portletInfoMD = jbossPortletMD.getPortletInfo()) != null) {
                    containerInfo.setAttachment(PortletInfoInfo.class, (Object)new PortletInfoInfoImpl((PortletApplicationContext)new PortletApplicationContextImpl((WebApp)this.builderContext.getWebApp()), portletInfoMD));
                }
                if ((txType = jbossPortletMD.getTxType()) != null) {
                    containerInfo.setAttachment(TransactionInfo.class, (Object)new TransactionInfoImpl(jbossPortletMD.getTxType()));
                }
                if ((distributed = jbossPortletMD.getDistributed()) != null) {
                    containerInfo.setAttachment(SessionInfo.class, (Object)new SessionInfoImpl(distributed));
                }
                if ((remotable = jbossPortletMD.getRemotable()) != null) {
                    containerInfo.setAttachment(WSRPInfo.class, (Object)new WSRPInfoImpl(remotable));
                }
            }
            this.portlets.put(name, (PortletInfo)containerInfo);
        }
    }
}

